@extends('layouts.admin')
@section('title', 'Employee Documents')
@section('content')
<div class="p-4 sm:p-6 lg:ml-64"><div class="max-w-7xl mx-auto">
  <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900 mb-2">Employee Documents</h1>
  <p class="text-sm text-gray-600 mb-4">Manage employee files, IDs, contracts, and compliance docs.</p>

  <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
    <div class="bg-white border rounded p-4"><p class="text-xs text-gray-500">Employees</p><p class="text-xl sm:text-2xl lg:text-3xl font-bold">{{ $employeesCount ?? 0 }}</p></div>
    <div class="bg-white border rounded p-4"><p class="text-xs text-gray-500">Branches</p><p class="text-xl sm:text-2xl lg:text-3xl font-bold">{{ $branchesCount ?? 0 }}</p></div>
    <div class="bg-white border rounded p-4"><p class="text-xs text-gray-500">Docs Uploaded</p><p class="text-xl sm:text-2xl lg:text-3xl font-bold">0</p></div>
  </div>

  <div class="mt-6 grid grid-cols-1 lg:grid-cols-2 gap-4">
    <div class="bg-white border rounded">
      <div class="p-4 border-b flex justify-between items-center">
        <h2 class="text-sm font-semibold">Quick Actions</h2>
        <div class="text-xs text-gray-500">Files</div>
      </div>
      <div class="p-4 grid grid-cols-2 gap-3">
        <a href="#" class="text-[11px] px-3 py-2 border rounded hover:bg-gray-50">Upload Document</a>
        <a href="#" class="text-[11px] px-3 py-2 border rounded hover:bg-gray-50">Generate Checklist</a>
        <a href="#" class="text-[11px] px-3 py-2 border rounded hover:bg-gray-50">Map Document Types</a>
        <a href="#" class="text-[11px] px-3 py-2 border rounded hover:bg-gray-50">Bulk Assign</a>
      </div>
    </div>

    <div class="bg-white border rounded overflow-x-auto">
      <div class="p-4 border-b"><h2 class="text-sm font-semibold">Recent Employees</h2></div>
      <table class="min-w-full">
        <thead class="bg-gray-50">
          <tr><th class="px-4 py-2 text-left text-[11px] text-gray-700">Name</th><th class="px-4 py-2 text-left text-[11px] text-gray-700">Email</th><th class="px-4 py-2"></th></tr>
        </thead>
        <tbody class="divide-y">
          @forelse(($recentEmployees ?? []) as $emp)
            <tr>
              <td class="px-4 py-2 text-sm">{{ $emp->name ?? '—' }}</td>
              <td class="px-4 py-2 text-xs text-gray-600">{{ $emp->email ?? '—' }}</td>
              <td class="px-4 py-2 text-right"><a href="#" class="text-[11px] px-2 py-1 border rounded hover:bg-gray-50">View Docs</a></td>
            </tr>
          @empty
            <tr><td colspan="3" class="px-4 py-6 text-center text-sm text-gray-600">No employees yet.</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>
</div></div>
@endsection
