@extends('layouts.admin')

@section('title', $pageTitle ?? 'Exit & Handover')

@section('content')
<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="h4 mb-0">Exit & Handover</h2>
        <div>
            <span class="badge bg-primary me-2">Employees: {{ $employeeCount }}</span>
            <span class="badge bg-secondary">Branches: {{ $branchCount }}</span>
        </div>
    </div>

    @if(session('status'))
        <div class="alert alert-success">{{ session('status') }}</div>
    @endif

    <div class="row">
        <div class="col-lg-7 mb-4">
            <div class="card shadow-sm">
                <div class="card-header">Process Exit & Handover</div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.hr.exit-handover.process') }}">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">Employee</label>
                            <select name="employee_id" class="form-select" required>
                                @foreach($recentEmployees as $emp)
                                    <option value="{{ $emp->id }}">{{ $emp->name }} @isset($emp->position) ({{ $emp->position }}) @endisset</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Last Working Day</label>
                            <input type="date" name="last_day" class="form-control" required />
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Reason</label>
                            <input type="text" name="reason" class="form-control" placeholder="Resignation / Termination / Retirement" />
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Handover Notes</label>
                            <textarea name="handover_notes" class="form-control" rows="4" placeholder="Assets returned, credentials revoked, responsibilities transferred..."></textarea>
                        </div>
                        <div class="form-check mb-3">
                            <input type="checkbox" name="documents_collected" value="1" class="form-check-input" id="docsCollected">
                            <label class="form-check-label" for="docsCollected">All documents collected</label>
                        </div>
                        <button type="submit" class="btn btn-primary">Process Exit</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-5 mb-4">
            <div class="card shadow-sm">
                <div class="card-header">Recent Employees</div>
                <ul class="list-group list-group-flush">
                    @forelse($recentEmployees as $emp)
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>{{ $emp->name }} @isset($emp->position)<small class="text-muted"> ({{ $emp->position }})</small>@endisset</span>
                            <a href="#" class="btn btn-sm btn-outline-secondary">View</a>
                        </li>
                    @empty
                        <li class="list-group-item">No recent employees</li>
                    @endforelse
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection
