@extends('layouts.admin')

@section('title', 'Leave Management')

@section('content')
<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Leave Management</h1>
        <a href="{{ route('admin.hr.attendance') }}" class="btn btn-outline-secondary">Back to Attendance</a>
    </div>

    @if(session('status'))
        <div class="alert alert-success">{{ session('status') }}</div>
    @endif

    <div class="card mb-4">
        <div class="card-body">
            <div class="fw-semibold mb-2">Apply for Leave</div>
            <form method="POST" action="{{ route('admin.hr.leaves.apply') }}" class="row g-3">
                @csrf
                <div class="col-md-3">
                    <label class="form-label">Employee ID</label>
                    <input type="number" class="form-control" name="employee_id" required />
                </div>
                <div class="col-md-3">
                    <label class="form-label">Type</label>
                    <input type="text" class="form-control" name="type" placeholder="e.g. Annual" required />
                </div>
                <div class="col-md-3">
                    <label class="form-label">From</label>
                    <input type="date" class="form-control" name="from" required />
                </div>
                <div class="col-md-3">
                    <label class="form-label">To</label>
                    <input type="date" class="form-control" name="to" required />
                </div>
                <div class="col-12 text-end">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header fw-semibold">Recent Employees</div>
        <div class="table-responsive">
            <table class="table table-striped mb-0">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Branch</th>
                        <th>Joined</th>
                    </tr>
                </thead>
                <tbody>
                @forelse(($recentEmployees ?? []) as $emp)
                    <tr>
                        <td>{{ $emp->name ?? '-' }}</td>
                        <td>{{ $emp->email ?? '-' }}</td>
                        <td>{{ $emp->branch->name ?? '-' }}</td>
                        <td>{{ optional($emp->created_at)->format('Y-m-d') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">No recent employees found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
