@extends('layouts.admin')

@section('title', 'Performance KPIs')

@section('content')
<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Performance KPIs</h1>
        <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">Back to Dashboard</a>
    </div>

    @if(session('status'))
        <div class="alert alert-success">{{ session('status') }}</div>
    @endif

    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="text-muted">Employees</div>
                    <div class="fs-4 fw-semibold">{{ $employeeCount ?? 0 }}</div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="text-muted">Branches</div>
                    <div class="fs-4 fw-semibold">{{ $branchCount ?? 0 }}</div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="fw-semibold mb-2">Submit Performance Review</div>
                    <form method="POST" action="{{ route('admin.hr.performance-kpis.store') }}" class="row g-3">
                        @csrf
                        <div class="col-md-3">
                            <label class="form-label">Employee ID</label>
                            <input type="number" class="form-control" name="employee_id" required />
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Rating</label>
                            <select class="form-select" name="rating" required>
                                @for($i=1;$i<=5;$i++)
                                    <option value="{{ $i }}">{{ $i }}</option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Notes</label>
                            <textarea class="form-control" rows="2" name="notes"></textarea>
                        </div>
                        <div class="col-12 text-end">
                            <button type="submit" class="btn btn-primary">Save Review</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header fw-semibold">Recent Employees</div>
        <div class="table-responsive">
            <table class="table table-striped mb-0">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Branch</th>
                        <th>Joined</th>
                    </tr>
                </thead>
                <tbody>
                @forelse(($recentEmployees ?? []) as $emp)
                    <tr>
                        <td>{{ $emp->name ?? '-' }}</td>
                        <td>{{ $emp->email ?? '-' }}</td>
                        <td>{{ $emp->branch->name ?? '-' }}</td>
                        <td>{{ optional($emp->created_at)->format('Y-m-d') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">No recent employees found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
