@extends('layouts.admin')

@section('title', 'Recruitment & Hiring')

@section('content')
<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Recruitment & Hiring</h1>
        <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">Back to Dashboard</a>
    </div>

    @if(session('status'))
        <div class="alert alert-success">{{ session('status') }}</div>
    @endif

    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-muted">Employees</div>
                            <div class="fs-4 fw-semibold">{{ $employeeCount ?? 0 }}</div>
                        </div>
                        <i class="bi bi-people fs-3 text-primary"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="text-muted">Branches</div>
                            <div class="fs-4 fw-semibold">{{ $branchCount ?? 0 }}</div>
                        </div>
                        <i class="bi bi-diagram-3 fs-3 text-success"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div>
                            <div class="text-muted">Quick Actions</div>
                            <div class="fw-semibold">Start a Recruitment Request</div>
                        </div>
                        <i class="bi bi-clipboard-plus fs-3 text-info"></i>
                    </div>
                    <form method="POST" action="{{ route('admin.hr.recruitment.store') }}" class="row g-3">
                        @csrf
                        <div class="col-md-4">
                            <label class="form-label">Position</label>
                            <input type="text" class="form-control" name="position" placeholder="e.g. Sales Manager" />
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Department</label>
                            <input type="text" class="form-control" name="department" placeholder="e.g. Sales" />
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Openings</label>
                            <input type="number" min="1" class="form-control" name="openings" value="1" />
                        </div>
                        <div class="col-12 text-end">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span class="fw-semibold">Recent Employees</span>
            <i class="bi bi-hourglass-split text-secondary"></i>
        </div>
        <div class="table-responsive">
            <table class="table table-striped mb-0">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Branch</th>
                        <th>Joined</th>
                    </tr>
                </thead>
                <tbody>
                @forelse(($recentEmployees ?? []) as $emp)
                    <tr>
                        <td>{{ $emp->name ?? '-' }}</td>
                        <td>{{ $emp->email ?? '-' }}</td>
                        <td>{{ $emp->branch->name ?? '-' }}</td>
                        <td>{{ optional($emp->created_at)->format('Y-m-d') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">No recent employees found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
