@extends('layouts.admin')

@section('title', 'Route Optimization & Efficiency')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Route Optimization</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Analyze and improve route efficiency.</p>
        </div>
    </div>

    {{-- Summary Cards --}}
    <div class="grid grid-cols-1 md:grid-cols-3 gap-3 sm:gap-4 lg:gap-6 mb-4 sm:mb-6">
        <div class="bg-white p-6 rounded-lg border border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">Total Routes</h3>
            <p class="mt-2 text-3xl font-bold text-gray-900">{{ $routes->count() }}</p>
        </div>
        <div class="bg-white p-6 rounded-lg border border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">Avg. Efficiency</h3>
            <p class="mt-2 text-3xl font-bold text-gray-900">93.5%</p> {{-- Placeholder --}}
        </div>
        <div class="bg-white p-6 rounded-lg border border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">Total Distance</h3>
            <p class="mt-2 text-3xl font-bold text-gray-900">57 km</p> {{-- Placeholder --}}
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        {{-- Routes Table --}}
        <div class="lg:col-span-2 bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <h2 class="text-lg font-semibold mb-4">Route Details</h2>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Route</th>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Rider</th>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Parcels</th>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Distance</th>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Time</th>
                            <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Efficiency</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($routes as $route)
                            <tr>
                                <td class="px-6 py-4 text-sm font-medium">{{ $route['name'] }}</td>
                                <td class="px-6 py-4 text-sm">{{ $route['rider'] }}</td>
                                <td class="px-6 py-4 text-sm">{{ $route['parcels'] }}</td>
                                <td class="px-6 py-4 text-sm">{{ $route['distance'] }}</td>
                                <td class="px-6 py-4 text-sm">{{ $route['time'] }}</td>
                                <td class="px-6 py-4 text-sm font-semibold">{{ $route['efficiency'] }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        {{-- Map Placeholder --}}
        <div class="lg:col-span-1 bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <h2 class="text-lg font-semibold mb-4">Route Visualization</h2>
            <div class="bg-gray-200 h-64 rounded-md flex items-center justify-center">
                <p class="text-gray-500">Map will be displayed here.</p>
            </div>
        </div>
    </div>
</div>
@endsection



