@extends('layouts.admin')

@section('content')
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Edit Contract</h3>
  </div>
  <div class="card-body">
    <form action="{{ route('admin.marketing.contracts.update', $contract->id) }}" method="POST" enctype="multipart/form-data">
      @csrf
      @method('PUT')
      <div class="mb-3">
        <label for="merchant_id" class="form-label">Merchant</label>
        <select class="form-select" id="merchant_id" name="merchant_id" required>
          @foreach (\App\Models\Merchant::all() as $merchant)
            <option value="{{ $merchant->id }}" {{ $contract->merchant_id === $merchant->id ? 'selected' : '' }}>{{ $merchant->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="mb-3">
        <label for="start_date" class="form-label">Start Date</label>
        <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $contract->start_date }}" required>
      </div>
      <div class="mb-3">
        <label for="end_date" class="form-label">End Date</label>
        <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $contract->end_date }}" required>
      </div>
      <div class="mb-3">
        <label for="document" class="form-label">Contract Document</label>
        <input type="file" class="form-control" id="document" name="document">
        @if ($contract->document_path)
          <a href="{{ Storage::url($contract->document_path) }}" target="_blank">View Current Document</a>
        @endif
      </div>
      <button type="submit" class="btn btn-primary">Update Contract</button>
    </form>
  </div>
</div>
@endsection
