@extends('layouts.admin')

@section('title', 'Lead Management')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-4">
        <h1 class="text-2xl font-semibold">Lead Management</h1>
        <a href="{{ route('admin.marketing.leads.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-md">Add New Lead</a>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="text-sm text-gray-600">Total Leads</div>
            <div class="text-2xl font-bold">{{ $leads->total() }}</div>
        </div>
        <div class="bg-green-50 rounded-lg shadow-md p-4">
            <div class="text-sm text-gray-600">Converted</div>
            <div class="text-2xl font-bold text-green-600">{{ \App\Models\Lead::where('status', 'converted')->count() }}</div>
        </div>
        <div class="bg-yellow-50 rounded-lg shadow-md p-4">
            <div class="text-sm text-gray-600">In Progress</div>
            <div class="text-2xl font-bold text-yellow-600">{{ \App\Models\Lead::whereIn('status', ['contacted', 'qualified'])->count() }}</div>
        </div>
        <div class="bg-red-50 rounded-lg shadow-md p-4">
            <div class="text-sm text-gray-600">Lost</div>
            <div class="text-2xl font-bold text-red-600">{{ \App\Models\Lead::where('status', 'lost')->count() }}</div>
        </div>
    </div>

    <!-- Leads Table -->
    <div class="bg-white rounded-lg shadow-md overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Company</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Territory</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Value</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($leads as $lead)
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $lead->name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $lead->company }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $lead->territory->name ?? 'N/A' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                @if($lead->status == 'converted') bg-green-100 text-green-800
                                @elseif($lead->status == 'lost') bg-red-100 text-red-800
                                @else bg-yellow-100 text-yellow-800
                                @endif">
                                {{ ucfirst($lead->status) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">PKR {{ number_format($lead->value ?? 0) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <a href="{{ route('admin.marketing.leads.edit', $lead) }}" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-4 text-center text-gray-500">No leads found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $leads->links() }}
    </div>
</div>
@endsection

