@extends('layouts.admin')

@section('title', 'Pipeline Tracker')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h1 class="text-2xl font-semibold mb-4">Sales Pipeline Tracker</h1>

    <!-- Pipeline Stages -->
    <div class="grid grid-cols-2 md:grid-cols-5 gap-4 mb-6">
        <div class="bg-blue-50 rounded-lg shadow-md p-4 text-center">
            <div class="text-3xl font-bold text-blue-600">{{ $pipeline['new'] }}</div>
            <div class="text-sm text-gray-600 mt-1">New Leads</div>
        </div>
        <div class="bg-yellow-50 rounded-lg shadow-md p-4 text-center">
            <div class="text-3xl font-bold text-yellow-600">{{ $pipeline['contacted'] }}</div>
            <div class="text-sm text-gray-600 mt-1">Contacted</div>
        </div>
        <div class="bg-purple-50 rounded-lg shadow-md p-4 text-center">
            <div class="text-3xl font-bold text-purple-600">{{ $pipeline['qualified'] }}</div>
            <div class="text-sm text-gray-600 mt-1">Qualified</div>
        </div>
        <div class="bg-green-50 rounded-lg shadow-md p-4 text-center">
            <div class="text-3xl font-bold text-green-600">{{ $pipeline['converted'] }}</div>
            <div class="text-sm text-gray-600 mt-1">Converted</div>
        </div>
        <div class="bg-red-50 rounded-lg shadow-md p-4 text-center">
            <div class="text-3xl font-bold text-red-600">{{ $pipeline['lost'] }}</div>
            <div class="text-sm text-gray-600 mt-1">Lost</div>
        </div>
    </div>

    <!-- Recent Leads -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="text-lg font-semibold mb-4">Recent Leads Activity</h2>
        <div class="space-y-3">
            @foreach($leads as $lead)
                <div class="flex items-center justify-between p-3 bg-gray-50 rounded">
                    <div>
                        <div class="font-semibold">{{ $lead->name }}</div>
                        <div class="text-sm text-gray-600">{{ $lead->company }}</div>
                    </div>
                    <div class="text-right">
                        <span class="px-3 py-1 text-xs font-semibold rounded-full 
                            @if($lead->status == 'converted') bg-green-100 text-green-800
                            @elseif($lead->status == 'lost') bg-red-100 text-red-800
                            @else bg-yellow-100 text-yellow-800
                            @endif">
                            {{ ucfirst($lead->status) }}
                        </span>
                        <div class="text-sm text-gray-500 mt-1">{{ $lead->created_at->diffForHumans() }}</div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
@endsection

