@extends('layouts.admin')

@section('title', 'Target vs Achievement')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h1 class="text-2xl font-semibold mb-4">Target vs Achievement</h1>

    <!-- Overall Stats -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="text-sm text-gray-600">Total Target</div>
            <div class="text-3xl font-bold text-blue-600">PKR {{ number_format($stats['total_target']) }}</div>
        </div>
        <div class="bg-green-50 rounded-lg shadow-md p-6">
            <div class="text-sm text-gray-600">Achieved</div>
            <div class="text-3xl font-bold text-green-600">PKR {{ number_format($stats['achieved']) }}</div>
            <div class="text-sm text-gray-500 mt-1">{{ $stats['total_target'] > 0 ? number_format(($stats['achieved'] / $stats['total_target']) * 100, 1) : 0 }}% of target</div>
        </div>
        <div class="bg-yellow-50 rounded-lg shadow-md p-6">
            <div class="text-sm text-gray-600">Pending</div>
            <div class="text-3xl font-bold text-yellow-600">PKR {{ number_format($stats['pending']) }}</div>
        </div>
    </div>

    <!-- Territory Performance -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="text-lg font-semibold mb-4">Territory Performance</h2>
        <div class="space-y-4">
            @foreach($territories as $territory)
                @php
                    $achieved = $territory->leads->where('status', 'converted')->sum('value');
                    $target = $territory->target_amount ?? 1;
                    $percentage = ($achieved / $target) * 100;
                @endphp
                <div>
                    <div class="flex justify-between mb-2">
                        <span class="font-semibold">{{ $territory->name }}</span>
                        <span class="text-sm text-gray-600">PKR {{ number_format($achieved) }} / PKR {{ number_format($target) }}</span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-4">
                        <div class="bg-blue-600 h-4 rounded-full" style="width: {{ min($percentage, 100) }}%"></div>
                    </div>
                    <div class="text-sm text-gray-500 mt-1">{{ number_format($percentage, 1) }}% achieved</div>
                </div>
            @endforeach
        </div>
    </div>
</div>
@endsection

