@extends('layouts.admin')

@section('title', 'Territory Mapping')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-4">
        <h1 class="text-2xl font-semibold">Territory Mapping</h1>
        <a href="{{ route('admin.marketing.territories.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-md">Add Territory</a>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        @foreach($territories as $territory)
            <div class="bg-white rounded-lg shadow-md p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold">{{ $territory->name }}</h3>
                    <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm">{{ $territory->leads_count }} Leads</span>
                </div>
                <div class="space-y-2">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Target:</span>
                        <span class="font-semibold">PKR {{ number_format($territory->target_amount ?? 0) }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Manager:</span>
                        <span class="font-semibold">{{ $territory->manager ?? 'Unassigned' }}</span>
                    </div>
                </div>
                <div class="mt-4 pt-4 border-t flex gap-2">
                    <a href="{{ route('admin.marketing.territories.edit', $territory) }}" class="flex-1 text-center bg-indigo-600 text-white px-3 py-2 rounded text-sm">Edit</a>
                    <a href="{{ route('admin.marketing.territories.show', $territory) }}" class="flex-1 text-center bg-gray-200 text-gray-800 px-3 py-2 rounded text-sm">View</a>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endsection

