@extends('layouts.admin')

@section('title', 'Edit Compliance Document')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Edit Compliance Document</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Update document details</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <form action="{{ route('admin.marketing.documents.compliance.update', $document) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Title</label>
                    <input type="text" name="title" value="{{ old('title', $document->title) }}" class="mt-1 w-full border rounded px-3 py-2" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Code</label>
                    <input type="text" name="code" value="{{ old('code', $document->code) }}" class="mt-1 w-full border rounded px-3 py-2" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Category</label>
                    <input type="text" name="category" value="{{ old('category', $document->category) }}" class="mt-1 w-full border rounded px-3 py-2">
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Status</label>
                    <select name="status" class="mt-1 w-full border rounded px-3 py-2">
                        <option value="draft" @selected($document->status==='draft')>Draft</option>
                        <option value="active" @selected($document->status==='active')>Active</option>
                        <option value="archived" @selected($document->status==='archived')>Archived</option>
                    </select>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Effective Date</label>
                    <input type="date" name="effective_date" value="{{ old('effective_date', optional($document->effective_date)->format('Y-m-d')) }}" class="mt-1 w-full border rounded px-3 py-2">
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Expires At</label>
                    <input type="date" name="expires_at" value="{{ old('expires_at', optional($document->expires_at)->format('Y-m-d')) }}" class="mt-1 w-full border rounded px-3 py-2">
                </div>
                <div class="md:col-span-2">
                    <label class="inline-flex items-center text-sm text-gray-700">
                        <input type="checkbox" name="is_required" value="1" class="mr-2" @checked($document->is_required)> Required document
                    </label>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                    <textarea name="description" rows="3" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('description', $document->description) }}</textarea>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Content</label>
                    <textarea name="content" rows="8" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('content', $document->content) }}</textarea>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Notes</label>
                    <textarea name="notes" rows="3" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('notes', $document->notes) }}</textarea>
                </div>
            </div>
            <div class="mt-6 flex items-center justify-between">
                <a href="{{ route('admin.marketing.documents.compliance.index') }}" class="text-gray-600 hover:underline">Cancel</a>
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Changes</button>
            </div>
        </form>
    </div>
</div>
@endsection


