@extends('layouts.admin')

@section('title', 'Compliance Documents')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Compliance Documents</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage compliance and regulatory documents</p>
        </div>
        <a href="{{ route('admin.marketing.documents.compliance.create') }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create Document</a>
    </div>

    @if(session('success'))
        <div class="mb-4 p-3 bg-green-50 border border-green-200 text-green-700 rounded">{{ session('success') }}</div>
    @endif

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                    <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Code</th>
                    <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Category</th>
                    <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Effective</th>
                    <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($documents as $doc)
                <tr>
                    <td class="px-6 py-4 text-sm text-gray-900">{{ $doc->title }}</td>
                    <td class="px-6 py-4 text-sm text-gray-600">{{ $doc->code }}</td>
                    <td class="px-6 py-4 text-sm text-gray-600">{{ $doc->category ?? '-' }}</td>
                    <td class="px-6 py-4 text-sm">
                        <span class="px-2 py-1 text-xs rounded {{ $doc->status === 'active' ? 'bg-green-100 text-green-700' : ($doc->status === 'draft' ? 'bg-yellow-100 text-yellow-700' : 'bg-gray-100 text-gray-700') }}">{{ ucfirst($doc->status) }}</span>
                    </td>
                    <td class="px-6 py-4 text-sm text-gray-600">{{ optional($doc->effective_date)->format('Y-m-d') ?? '-' }}</td>
                    <td class="px-6 py-4 text-sm text-right">
                        <a href="{{ route('admin.marketing.documents.compliance.show', $doc) }}" class="text-blue-600 hover:underline mr-3">View</a>
                        <a href="{{ route('admin.marketing.documents.compliance.edit', $doc) }}" class="text-indigo-600 hover:underline mr-3">Edit</a>
                        <form action="{{ route('admin.marketing.documents.compliance.destroy', $doc) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:underline" onclick="return confirm('Delete this document?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-600">No compliance documents found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
        <div class="px-6 py-3 border-t">{{ $documents->links() }}</div>
    </div>
</div>
@endsection


