@extends('layouts.admin')

@section('title', 'Compliance Document Details')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">{{ $document->title }}</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Code: {{ $document->code }} • Status: {{ ucfirst($document->status) }}</p>
        </div>
        <div>
            <a href="{{ route('admin.marketing.documents.compliance.edit', $document) }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">Edit</a>
            <a href="{{ route('admin.marketing.documents.compliance.index') }}" class="ml-3 text-gray-700 hover:underline">Back</a>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="md:col-span-2 bg-white rounded-lg border border-gray-200 p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-3">Content</h3>
            <div class="prose max-w-none">
                {!! nl2br(e($document->content)) !!}
            </div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-3">Metadata</h3>
            <ul class="text-sm text-gray-700 space-y-2">
                <li><strong>Category:</strong> {{ $document->category ?? '-' }}</li>
                <li><strong>Effective Date:</strong> {{ optional($document->effective_date)->format('Y-m-d') ?? '-' }}</li>
                <li><strong>Expires At:</strong> {{ optional($document->expires_at)->format('Y-m-d') ?? '-' }}</li>
                <li><strong>Required:</strong> {{ $document->is_required ? 'Yes' : 'No' }}</li>
                <li><strong>Created By:</strong> {{ $document->created_by ?? '-' }}</li>
                <li><strong>Updated By:</strong> {{ $document->updated_by ?? '-' }}</li>
                <li><strong>Description:</strong> {{ $document->description ?? '-' }}</li>
                <li><strong>Notes:</strong> {{ $document->notes ?? '-' }}</li>
            </ul>
        </div>
    </div>
</div>
@endsection
