@extends('layouts.admin')

@section('title', 'Edit Contract')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Edit Contract</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Update contract details</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <form method="POST" action="{{ route('admin.marketing.documents.contracts.update', $contract) }}" enctype="multipart/form-data" class="space-y-4">
            @csrf
            @method('PUT')
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Title</label>
                <input name="title" value="{{ old('title', $contract->title) }}" class="mt-1 w-full border rounded px-3 py-2" required />
                @error('title')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Contract Number</label>
                <input name="contract_number" value="{{ old('contract_number', $contract->contract_number) }}" class="mt-1 w-full border rounded px-3 py-2" required />
                @error('contract_number')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Start Date</label>
                    <input type="date" name="start_date" value="{{ old('start_date', $contract->start_date) }}" class="mt-1 w-full border rounded px-3 py-2" />
                    @error('start_date')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">End Date</label>
                    <input type="date" name="end_date" value="{{ old('end_date', $contract->end_date) }}" class="mt-1 w-full border rounded px-3 py-2" />
                    @error('end_date')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Status</label>
                <select name="status" class="mt-1 w-full border rounded px-3 py-2" required>
                    @foreach(['draft','active','expired','terminated'] as $status)
                        <option value="{{ $status }}" @selected(old('status', $contract->status) === $status)>{{ ucfirst($status) }}</option>
                    @endforeach
                </select>
                @error('status')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Upload File</label>
                <input type="file" name="file" class="mt-1 w-full" />
                @if($contract->file_path)
                    <p class="text-xs sm:text-sm text-gray-600 mt-1">Current: <a class="text-blue-600 hover:underline" href="{{ asset('storage/'.$contract->file_path) }}" target="_blank">Download</a></p>
                @endif
                @error('file')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Notes</label>
                <textarea name="notes" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" rows="4">{{ old('notes', $contract->notes) }}</textarea>
                @error('notes')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
            </div>
            <div class="pt-2">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update</button>
                <a href="{{ route('admin.marketing.documents.contracts.index') }}" class="ml-2 px-4 py-2 border rounded">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection


