@extends('layouts.admin')

@section('title', 'Contracts')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Contracts</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">List of all contracts</p>
        </div>
        <a href="{{ route('admin.marketing.documents.contracts.create') }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">New Contract</a>
    </div>

    @if(session('success'))
        <div class="mb-4 p-3 bg-green-100 text-green-700 rounded">{{ session('success') }}</div>
    @endif

    <div class="bg-white rounded-lg shadow-md">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Title</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Number</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Start</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">End</th>
                    <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($contracts as $contract)
                <tr>
                    <td class="px-4 py-2">{{ $contract->title }}</td>
                    <td class="px-4 py-2">{{ $contract->contract_number }}</td>
                    <td class="px-4 py-2">
                        <span class="px-2 py-1 text-xs rounded bg-gray-100">{{ ucfirst($contract->status) }}</span>
                    </td>
                    <td class="px-4 py-2">{{ $contract->start_date }}</td>
                    <td class="px-4 py-2">{{ $contract->end_date }}</td>
                    <td class="px-4 py-2 text-right space-x-2">
                        <a href="{{ route('admin.marketing.documents.contracts.show', $contract) }}" class="text-blue-600 hover:underline">View</a>
                        <a href="{{ route('admin.marketing.documents.contracts.edit', $contract) }}" class="text-indigo-600 hover:underline">Edit</a>
                        <form action="{{ route('admin.marketing.documents.contracts.destroy', $contract) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:underline" onclick="return confirm('Delete this contract?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-4 py-8 text-center text-gray-500">No contracts found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
        <div class="p-4">{{ $contracts->links() }}</div>
    </div>
</div>
@endsection

