@extends('layouts.admin')

@section('title', 'Contract Details')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">{{ $contract->title }}</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Contract #{{ $contract->contract_number }}</p>
        </div>
        <a href="{{ route('admin.marketing.documents.contracts.edit', $contract) }}" class="px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700">Edit</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 space-y-4">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <div class="text-sm text-gray-500">Status</div>
                <div class="text-gray-900">{{ ucfirst($contract->status) }}</div>
            </div>
            <div>
                <div class="text-sm text-gray-500">Start Date</div>
                <div class="text-gray-900">{{ $contract->start_date }}</div>
            </div>
            <div>
                <div class="text-sm text-gray-500">End Date</div>
                <div class="text-gray-900">{{ $contract->end_date }}</div>
            </div>
        </div>

        @if($contract->file_path)
        <div>
            <div class="text-sm text-gray-500">File</div>
            <a class="text-blue-600 hover:underline" href="{{ asset('storage/'.$contract->file_path) }}" target="_blank">Download</a>
        </div>
        @endif

        <div>
            <div class="text-sm text-gray-500">Notes</div>
            <div class="text-gray-900 whitespace-pre-line">{{ $contract->notes }}</div>
        </div>
    </div>
</div>
@endsection

