@extends('layouts.admin')

@section('title', 'Edit Template')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Edit Template</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Update document template</p>
        </div>
        <a href="{{ route('admin.marketing.documents.templates.index') }}" class="px-4 py-2 bg-gray-100 text-gray-700 rounded hover:bg-gray-200">Back</a>
    </div>

    @if ($errors->any())
        <div class="mb-4 p-3 bg-red-100 text-red-700 rounded">
            <ul class="list-disc list-inside">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.marketing.documents.templates.update', $template) }}" method="POST" class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 space-y-4">
        @csrf
        @method('PUT')
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Title</label>
                <input type="text" name="title" value="{{ old('title', $template->title) }}" class="mt-1 w-full border-gray-300 rounded" required>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Code</label>
                <input type="text" name="code" value="{{ old('code', $template->code) }}" class="mt-1 w-full border-gray-300 rounded" required>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Category</label>
                <input type="text" name="category" value="{{ old('category', $template->category) }}" class="mt-1 w-full border-gray-300 rounded">
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Version</label>
                <input type="text" name="version" value="{{ old('version', $template->version) }}" class="mt-1 w-full border-gray-300 rounded">
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Status</label>
                <select name="status" class="mt-1 w-full border-gray-300 rounded">
                    <option value="draft" {{ old('status', $template->status) === 'draft' ? 'selected' : '' }}>Draft</option>
                    <option value="active" {{ old('status', $template->status) === 'active' ? 'selected' : '' }}>Active</option>
                    <option value="archived" {{ old('status', $template->status) === 'archived' ? 'selected' : '' }}>Archived</option>
                </select>
            </div>
            <div class="flex items-center">
                <input type="checkbox" id="is_global" name="is_global" value="1" {{ old('is_global', $template->is_global) ? 'checked' : '' }} class="mr-2">
                <label for="is_global" class="text-sm font-medium text-gray-700">Global template</label>
            </div>
        </div>
        <div>
            <label class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
            <textarea name="description" rows="3" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('description', $template->description) }}</textarea>
        </div>
        <div>
            <label class="block text-xs sm:text-sm font-medium text-gray-700">Content</label>
            <textarea name="content" rows="10" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>{{ old('content', $template->content) }}</textarea>
        </div>
        <div>
            <label class="block text-xs sm:text-sm font-medium text-gray-700">Notes</label>
            <textarea name="notes" rows="3" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('notes', $template->notes) }}</textarea>
        </div>
        <div class="flex justify-end space-x-2">
            <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update</button>
            <a href="{{ route('admin.marketing.documents.templates.index') }}" class="px-4 py-2 bg-gray-100 text-gray-700 rounded hover:bg-gray-200">Cancel</a>
        </div>
    </form>
</div>
@endsection


