@extends('layouts.admin')

@section('title', 'Template Details')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Template Details</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">View template information</p>
        </div>
        <div class="space-x-2">
            <a href="{{ route('admin.marketing.documents.templates.index') }}" class="px-4 py-2 bg-gray-100 text-gray-700 rounded hover:bg-gray-200">Back</a>
            <a href="{{ route('admin.marketing.documents.templates.edit', $template) }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Edit</a>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 space-y-4">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <p class="text-sm text-gray-600">Title</p>
                <p class="text-gray-900 font-medium">{{ $template->title }}</p>
            </div>
            <div>
                <p class="text-sm text-gray-600">Code</p>
                <p class="text-gray-900 font-medium">{{ $template->code }}</p>
            </div>
            <div>
                <p class="text-sm text-gray-600">Category</p>
                <p class="text-gray-900 font-medium">{{ $template->category }}</p>
            </div>
            <div>
                <p class="text-sm text-gray-600">Status</p>
                <p class="text-gray-900 font-medium">{{ ucfirst($template->status) }}</p>
            </div>
            <div>
                <p class="text-sm text-gray-600">Version</p>
                <p class="text-gray-900 font-medium">{{ $template->version }}</p>
            </div>
            <div>
                <p class="text-sm text-gray-600">Global</p>
                <p class="text-gray-900 font-medium">{{ $template->is_global ? 'Yes' : 'No' }}</p>
            </div>
        </div>
        <div>
            <p class="text-sm text-gray-600">Description</p>
            <p class="text-gray-900">{{ $template->description }}</p>
        </div>
        <div>
            <p class="text-sm text-gray-600">Content</p>
            <pre class="text-gray-900 bg-gray-50 p-4 rounded overflow-auto">{{ $template->content }}</pre>
        </div>
        <div>
            <p class="text-sm text-gray-600">Notes</p>
            <p class="text-gray-900">{{ $template->notes }}</p>
        </div>
    </div>
</div>
@endsection

