@extends('layouts.admin')

@section('title', 'Edit Lead')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Edit Lead</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Update lead details and keep your pipeline accurate.</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <form action="{{ route('admin.marketing.leads.update', $lead->id) }}" method="POST" class="space-y-4">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm font-medium text-gray-700">Company Name <span class="text-red-600">*</span></label>
                    <input type="text" name="company_name" value="{{ old('company_name', $lead->company_name) }}"
                           class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Contact Person <span class="text-red-600">*</span></label>
                    <input type="text" name="contact_person" value="{{ old('contact_person', $lead->contact_person) }}"
                           class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Email <span class="text-red-600">*</span></label>
                    <input type="email" name="email" value="{{ old('email', $lead->email) }}"
                           class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Phone <span class="text-red-600">*</span></label>
                    <input type="text" name="phone" value="{{ old('phone', $lead->phone) }}"
                           class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Status <span class="text-red-600">*</span></label>
                    <select name="status" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                        <option value="Prospect" @selected(old('status', $lead->status) === 'Prospect')>Prospect</option>
                        <option value="Demo" @selected(old('status', $lead->status) === 'Demo')>Demo</option>
                        <option value="Onboard" @selected(old('status', $lead->status) === 'Onboard')>Onboard</option>
                        <option value="Active" @selected(old('status', $lead->status) === 'Active')>Active</option>
                    </select>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Estimated Value (PKR)</label>
                    <input type="number" name="value" step="0.01" min="0" value="{{ old('value', $lead->value) }}"
                           class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Assigned To <span class="text-red-600">*</span></label>
                    <select name="user_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                        @foreach (\App\Models\User::all() as $user)
                            <option value="{{ $user->id }}" @selected(old('user_id', $lead->user_id) === $user->id)>{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div>
                <label class="text-sm font-medium text-gray-700">Notes</label>
                <textarea name="notes" rows="3" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                          placeholder="Add any additional notes...">{{ old('notes', $lead->notes) }}</textarea>
            </div>

            <div class="flex flex-wrap gap-2">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">
                    <i class="fas fa-save me-1"></i>
                    Update Lead
                </button>
                <a href="{{ route('admin.marketing.leads.index') }}" class="bg-gray-200 text-gray-800 px-4 py-2 rounded-md text-sm font-semibold hover:bg-gray-300 transition">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
