@extends('layouts.admin')

@section('title', 'Lead Management')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Lead Management</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Track leads from prospect to active merchant.</p>
        </div>
        <button onclick="toggleAddLeadForm()" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
            <i class="fas fa-plus-circle me-1"></i>
            <span id="addLeadBtnText">Add Lead</span>
        </button>
    </div>

    <!-- Add Lead Form (Hidden by default) -->
    <div id="addLeadForm" class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 mb-4" style="display: none;">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Add New Lead</h2>
        <form action="{{ route('admin.marketing.leads.store') }}" method="POST">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm font-medium text-gray-700">Company Name <span class="text-red-600">*</span></label>
                    <input type="text" name="company_name" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Contact Person <span class="text-red-600">*</span></label>
                    <input type="text" name="contact_person" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Email <span class="text-red-600">*</span></label>
                    <input type="email" name="email" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Phone <span class="text-red-600">*</span></label>
                    <input type="text" name="phone" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Status <span class="text-red-600">*</span></label>
                    <select name="status" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                        <option value="Prospect" selected>Prospect</option>
                        <option value="Demo">Demo</option>
                        <option value="Onboard">Onboard</option>
                        <option value="Active">Active</option>
                    </select>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Estimated Value (PKR)</label>
                    <input type="number" name="value" step="0.01" min="0" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Assigned To <span class="text-red-600">*</span></label>
                    <select name="user_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                        @foreach (\App\Models\User::all() as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="mt-4">
                <label class="text-sm font-medium text-gray-700">Notes</label>
                <textarea name="notes" rows="3" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" placeholder="Add any additional notes..."></textarea>
            </div>
            <div class="flex gap-2 mt-4">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">
                    <i class="fas fa-save me-1"></i>
                    Save Lead
                </button>
                <button type="button" onclick="toggleAddLeadForm()" class="bg-gray-200 text-gray-800 px-4 py-2 rounded-md text-sm font-semibold hover:bg-gray-300 transition">
                    Cancel
                </button>
            </div>
        </form>
    </div>

    <!-- Kanban Board -->
    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            @php
                $pipelineStages = ['Prospect', 'Demo', 'Onboard', 'Active'];
            @endphp
            @foreach ($pipelineStages as $stage)
                <div class="bg-gray-50 rounded-lg p-4">
                    <h3 class="font-semibold mb-4 text-center text-gray-900">{{ $stage }}</h3>
                    <div class="space-y-4">
                        @foreach ($leads->where('status', $stage) as $lead)
                            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 hover:shadow-md transition">
                                <div class="flex items-start gap-4">
                                    <img src="https://ui-avatars.com/api/?name={{ urlencode($lead->contact_person) }}&background=random&color=fff&size=40"
                                         class="w-10 h-10 rounded-full border border-gray-200"
                                         alt="{{ $lead->contact_person }}">
                                    <div class="flex-1">
                                        <p class="font-semibold text-gray-900">{{ $lead->company_name }}</p>
                                        <p class="text-sm text-gray-600">{{ $lead->contact_person }}</p>
                                        <p class="text-sm font-medium text-blue-600 mt-1">PKR {{ number_format($lead->value ?? 0) }}</p>
                                        <div class="flex items-center gap-2 mt-3">
                                            <a href="{{ route('admin.marketing.leads.edit', $lead->id) }}"
                                               class="text-xs sm:text-sm text-blue-600 hover:text-blue-700 font-semibold flex items-center gap-1">
                                                <i class="fas fa-edit"></i>
                                                Edit
                                            </a>
                                            <form action="{{ route('admin.marketing.leads.destroy', $lead->id) }}" method="POST"
                                                  class="inline-flex items-center"
                                                  onsubmit="return confirm('Are you sure you want to delete this lead?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit"
                                                        class="text-xs sm:text-sm text-red-600 hover:text-red-700 font-semibold flex items-center gap-1">
                                                    <i class="fas fa-trash"></i>
                                                    Delete
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        @if ($leads->where('status', $stage)->count() === 0)
                            <div class="text-center text-sm text-gray-500 py-10">
                                No leads in this stage.
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>

<script>
function toggleAddLeadForm() {
    const form = document.getElementById('addLeadForm');
    const btnText = document.getElementById('addLeadBtnText');
    
    if (form.style.display === 'none') {
        form.style.display = 'block';
        btnText.textContent = 'Cancel';
        // Scroll to form
        form.scrollIntoView({ behavior: 'smooth', block: 'start' });
    } else {
        form.style.display = 'none';
        btnText.textContent = 'Add Lead';
    }
}
</script>
@endsection
