@extends('layouts.admin')

@section('title', 'Marketing Management')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Marketing Management</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Overview of alerts, contracts, documents, and rates</p>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <div class="bg-white rounded-lg shadow p-4">
            <div class="text-xs text-gray-500">Total Alerts</div>
            <div class="text-2xl font-bold text-gray-900">{{ $totalAlerts }}</div>
            <a href="{{ route('admin.marketing.alerts') }}" class="mt-2 inline-block text-xs text-blue-600 hover:underline">View Alerts</a>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <div class="text-xs text-gray-500">Unread Alerts</div>
            <div class="text-2xl font-bold text-gray-900">{{ $unreadAlerts }}</div>
            <a href="{{ route('admin.marketing.alerts', ['status' => 'new']) }}" class="mt-2 inline-block text-xs text-blue-600 hover:underline">Filter New</a>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <div class="text-xs text-gray-500">Document Templates</div>
            <div class="text-2xl font-bold text-gray-900">{{ $templatesCount }}</div>
            <a href="{{ route('admin.marketing.documents.templates.index') }}" class="mt-2 inline-block text-xs text-blue-600 hover:underline">Manage Templates</a>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <div class="text-xs text-gray-500">Compliance Documents</div>
            <div class="text-2xl font-bold text-gray-900">{{ $complianceDocumentsCount }}</div>
            <a href="{{ route('admin.marketing.documents.compliance.index') }}" class="mt-2 inline-block text-xs text-blue-600 hover:underline">Manage Compliance</a>
        </div>
    </div>

    <!-- Recent Alerts & Expiring Contracts -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow-md">
            <div class="p-4 border-b">
                <h2 class="text-sm sm:text-base font-semibold text-gray-900">Recent Alerts</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Title</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Severity</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Triggered</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($recentAlerts as $a)
                        <tr>
                            <td class="px-4 py-2">
                                <div class="font-medium text-gray-900">{{ $a->title }}</div>
                                <div class="text-xs text-gray-600">{{ $a->description }}</div>
                            </td>
                            <td class="px-4 py-2">
                                @php
                                    $sevMap = [
                                        'info' => 'bg-blue-100 text-blue-800',
                                        'warning' => 'bg-yellow-100 text-yellow-800',
                                        'critical' => 'bg-red-100 text-red-800'
                                    ];
                                @endphp
                                <span class="px-2 py-1 rounded {{ $sevMap[$a->severity] ?? 'bg-gray-100 text-gray-800' }}">{{ $a->severity }}</span>
                            </td>
                            <td class="px-4 py-2">{{ optional($a->triggered_at)->format('Y-m-d H:i') }}</td>
                            <td class="px-4 py-2">
                                <form action="{{ route('admin.marketing.alerts.acknowledge', $a) }}" method="POST" class="inline">
                                    @csrf
                                    <button class="bg-green-600 text-white px-3 py-1 rounded hover:bg-green-700 text-xs">Acknowledge</button>
                                </form>
                                <button onclick="promptSnooze({{ $a->id }})" class="bg-yellow-600 text-white px-3 py-1 rounded hover:bg-yellow-700 text-xs">Snooze</button>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="px-4 py-3 text-center text-gray-500">No recent alerts</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="p-4 border-t text-right">
                <a href="{{ route('admin.marketing.alerts') }}" class="text-blue-600 hover:underline text-xs">Go to Alerts</a>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md">
            <div class="p-4 border-b">
                <h2 class="text-sm sm:text-base font-semibold text-gray-900">Expiring Contracts (next 60 days)</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Title</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Number</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">End Date</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($expiringContracts as $c)
                        <tr>
                            <td class="px-4 py-2">{{ $c->title }}</td>
                            <td class="px-4 py-2">{{ $c->contract_number }}</td>
                            <td class="px-4 py-2">{{ $c->end_date }}</td>
                            <td class="px-4 py-2">
                                <a href="{{ route('admin.marketing.documents.contracts.show', $c) }}" class="text-blue-600 hover:underline text-xs">View</a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="px-4 py-3 text-center text-gray-500">No expiring contracts</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="p-4 border-t text-right">
                <a href="{{ route('admin.marketing.documents.contracts.index') }}" class="text-blue-600 hover:underline text-xs">All Contracts</a>
            </div>
        </div>
    </div>

    <!-- Documents & Rates Quick Links -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow-md p-4">
            <h2 class="text-sm sm:text-base font-semibold text-gray-900 mb-3">Recent Templates</h2>
            <ul class="divide-y divide-gray-200 bg-white rounded">
                @forelse($recentTemplates as $t)
                    <li class="px-4 py-2 flex items-center justify-between">
                        <div>
                            <div class="text-sm font-medium text-gray-900">{{ $t->title }}</div>
                            <div class="text-xs text-gray-600">Code: {{ $t->code }} · Status: {{ ucfirst($t->status) }}</div>
                        </div>
                        <a href="{{ route('admin.marketing.documents.templates.edit', $t) }}" class="text-indigo-600 hover:underline text-xs">Edit</a>
                    </li>
                @empty
                    <li class="px-4 py-3 text-center text-gray-500">No recent templates</li>
                @endforelse
            </ul>
            <div class="mt-3 text-right">
                <a href="{{ route('admin.marketing.documents.templates.index') }}" class="text-blue-600 hover:underline text-xs">Manage Templates</a>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-4">
            <h2 class="text-sm sm:text-base font-semibold text-gray-900 mb-3">Rates Overview</h2>
            <div class="grid grid-cols-3 gap-4">
                <div class="bg-gray-50 rounded p-3 text-center">
                    <div class="text-[11px] text-gray-600">Pricing</div>
                    <div class="text-xl font-bold text-gray-900">{{ $pricingCount }}</div>
                    <a href="{{ route('admin.marketing.rates.pricing.index') }}" class="mt-1 inline-block text-[11px] text-blue-600 hover:underline">Manage</a>
                </div>
                <div class="bg-gray-50 rounded p-3 text-center">
                    <div class="text-[11px] text-gray-600">Discounts</div>
                    <div class="text-xl font-bold text-gray-900">{{ $discountCount }}</div>
                    <a href="{{ route('admin.marketing.rates.discounts.index') }}" class="mt-1 inline-block text-[11px] text-blue-600 hover:underline">Manage</a>
                </div>
                <div class="bg-gray-50 rounded p-3 text-center">
                    <div class="text-[11px] text-gray-600">Zone Rates</div>
                    <div class="text-xl font-bold text-gray-900">{{ $zoneRateCount }}</div>
                    <a href="{{ route('admin.marketing.rates.zones.index') }}" class="mt-1 inline-block text-[11px] text-blue-600 hover:underline">Manage</a>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        function promptSnooze(id) {
            const minutes = parseInt(prompt('Snooze for how many minutes?', '60'), 10);
            if (!isNaN(minutes) && minutes > 0) {
                fetch(`{{ route('admin.marketing.alerts.snooze', ['alert' => 0]) }}`.replace('0', id), {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({ minutes })
                });
            }
        }
    </script>
    @endpush
</div>
@endsection

