@extends('layouts.admin')

@section('title', 'Merchant Profiles')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Merchant Profiles</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">View and manage all merchant profiles and information</p>
    </div>

    <!-- Merchant Cards Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        @forelse ($merchants as $merchant)
            <div class="bg-white rounded-lg shadow-md p-4 hover:shadow-lg transition">
                <div class="flex items-start gap-4">
                    <div class="flex-shrink-0">
                        <div class="w-16 h-16 rounded-full bg-gradient-to-br from-blue-500 to-purple-600 flex items-center justify-center text-white text-2xl font-bold">
                            {{ strtoupper(substr($merchant->name, 0, 2)) }}
                        </div>
                    </div>
                    <div class="flex-1 min-w-0">
                        <h3 class="text-lg font-semibold text-gray-900 truncate">{{ $merchant->name }}</h3>
                        <div class="mt-2 space-y-1">
                            <p class="text-sm text-gray-600 flex items-center gap-2">
                                <i class="fas fa-user text-gray-400"></i>
                                {{ $merchant->contact_person ?? 'N/A' }}
                            </p>
                            <p class="text-sm text-gray-600 flex items-center gap-2">
                                <i class="fas fa-envelope text-gray-400"></i>
                                {{ $merchant->email }}
                            </p>
                            <p class="text-sm text-gray-600 flex items-center gap-2">
                                <i class="fas fa-phone text-gray-400"></i>
                                {{ $merchant->phone ?? 'N/A' }}
                            </p>
                        </div>
                        <div class="mt-4 flex gap-2">
                            <a href="{{ route('admin.merchants.show', $merchant->id) }}" 
                               class="flex-1 text-center bg-blue-600 text-white px-3 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">
                                <i class="fas fa-eye me-1"></i>
                                View Profile
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-span-full bg-white rounded-lg shadow-md p-8 text-center">
                <i class="fas fa-store fa-3x mb-3 text-gray-300"></i>
                <p class="text-gray-500">No merchant profiles found.</p>
            </div>
        @endforelse
    </div>

    <!-- Pagination if needed -->
    @if(method_exists($merchants, 'links'))
        <div class="mt-6">
            {{ $merchants->links() }}
        </div>
    @endif
</div>
@endsection
