@extends('layouts.admin')

@section('title', 'Sales Hierarchy')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Sales Hierarchy</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">View organizational structure and reporting lines</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <!-- Hierarchy Tree View -->
        <div class="space-y-4">
            @php
                $users = \App\Models\User::whereIn('role', ['Admin', 'Marketing Manager', 'Sales Manager'])->get();
                $territories = \App\Models\Territory::with('manager')->get();
            @endphp

            <!-- Top Level - Management -->
            <div class="border-l-4 border-blue-600 pl-4">
                <div class="flex items-center gap-3 mb-4">
                    <div class="w-12 h-12 rounded-full bg-blue-600 flex items-center justify-center text-white font-bold">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-gray-900">Management Team</h3>
                        <p class="text-sm text-gray-600">Executive & Leadership</p>
                    </div>
                </div>

                <!-- Territory Managers -->
                <div class="ml-8 space-y-3">
                    @forelse($territories as $territory)
                        <div class="border-l-4 border-green-500 pl-4 bg-gray-50 rounded-r-lg p-3">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-full bg-green-500 flex items-center justify-center text-white font-bold text-sm">
                                        {{ strtoupper(substr($territory->manager->name, 0, 2)) }}
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-900">{{ $territory->manager->name }}</h4>
                                        <p class="text-sm text-gray-600">
                                            <i class="fas fa-map-marker-alt text-gray-400 mr-1"></i>
                                            {{ $territory->name }}
                                        </p>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                        Territory Manager
                                    </span>
                                </div>
                            </div>
                            
                            <!-- Team Members under this territory -->
                            <div class="ml-8 mt-3 space-y-2">
                                @php
                                    $leads = \App\Models\Lead::where('user_id', $territory->user_id)->take(3)->get();
                                @endphp
                                @foreach($leads as $lead)
                                    <div class="flex items-center gap-2 text-sm text-gray-600 bg-white rounded p-2">
                                        <i class="fas fa-user-circle text-gray-400"></i>
                                        <span>{{ $lead->company_name }} - {{ $lead->contact_person }}</span>
                                        <span class="ml-auto px-2 py-0.5 text-xs rounded-full bg-blue-100 text-blue-800">
                                            {{ $lead->status }}
                                        </span>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-8 text-gray-500">
                            <i class="fas fa-sitemap fa-3x mb-3 text-gray-300"></i>
                            <p>No territories or managers found.</p>
                            <p class="text-sm mt-2">Add territories to build your sales hierarchy.</p>
                        </div>
                    @endforelse
                </div>
            </div>

            <!-- Statistics -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mt-6 pt-6 border-t">
                <div class="bg-blue-50 rounded-lg p-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-full bg-blue-600 flex items-center justify-center text-white">
                            <i class="fas fa-users"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Total Managers</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $territories->count() }}</p>
                        </div>
                    </div>
                </div>
                <div class="bg-green-50 rounded-lg p-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-full bg-green-600 flex items-center justify-center text-white">
                            <i class="fas fa-map-marked-alt"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Territories</p>
                            <p class="text-2xl font-bold text-gray-900">{{ $territories->count() }}</p>
                        </div>
                    </div>
                </div>
                <div class="bg-purple-50 rounded-lg p-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-full bg-purple-600 flex items-center justify-center text-white">
                            <i class="fas fa-user-friends"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Active Leads</p>
                            <p class="text-2xl font-bold text-gray-900">{{ \App\Models\Lead::count() }}</p>
                        </div>
                    </div>
                </div>
                <div class="bg-orange-50 rounded-lg p-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-full bg-orange-600 flex items-center justify-center text-white">
                            <i class="fas fa-store"></i>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Merchants</p>
                            <p class="text-2xl font-bold text-gray-900">{{ \App\Models\User::where('role', 'seller')->count() }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

