@extends('layouts.admin')

@section('title', 'Shipment Summary')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Shipment Summary</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Overview of all merchant shipments and delivery status</p>
    </div>

    <!-- Summary Stats -->
    <div class="grid grid-cols-1 md:grid-cols-5 gap-4 mb-6">
        @php
            $shipments = \App\Models\Parcel::latest()->get();
        @endphp
        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center">
                    <i class="fas fa-box text-blue-600"></i>
                </div>
                <div>
                    <p class="text-xs text-gray-600">Total Shipments</p>
                    <p class="text-xl font-bold text-gray-900">{{ $shipments->count() }}</p>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-full bg-yellow-100 flex items-center justify-center">
                    <i class="fas fa-clock text-yellow-600"></i>
                </div>
                <div>
                    <p class="text-xs text-gray-600">Pending</p>
                    <p class="text-xl font-bold text-gray-900">{{ $shipments->where('status', 'pending')->count() }}</p>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-full bg-purple-100 flex items-center justify-center">
                    <i class="fas fa-truck text-purple-600"></i>
                </div>
                <div>
                    <p class="text-xs text-gray-600">In Transit</p>
                    <p class="text-xl font-bold text-gray-900">{{ $shipments->where('status', 'in-transit')->count() }}</p>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center">
                    <i class="fas fa-check-circle text-green-600"></i>
                </div>
                <div>
                    <p class="text-xs text-gray-600">Delivered</p>
                    <p class="text-xl font-bold text-gray-900">{{ $shipments->where('status', 'delivered')->count() }}</p>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-full bg-red-100 flex items-center justify-center">
                    <i class="fas fa-times-circle text-red-600"></i>
                </div>
                <div>
                    <p class="text-xs text-gray-600">Failed</p>
                    <p class="text-xl font-bold text-gray-900">{{ $shipments->whereIn('status', ['failed', 'returned'])->count() }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Shipments Table -->
    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tracking ID</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Merchant</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Origin</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Destination</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse ($shipments as $shipment)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ $shipment->tracking_id }}</div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="text-sm text-gray-900">{{ $shipment->merchant->name ?? 'N/A' }}</div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="text-sm text-gray-900">{{ $shipment->origin_city ?? 'N/A' }}</div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="text-sm text-gray-900">{{ $shipment->destination_city ?? 'N/A' }}</div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                @php
                                    $statusColors = [
                                        'pending' => 'bg-yellow-100 text-yellow-800',
                                        'in-transit' => 'bg-blue-100 text-blue-800',
                                        'delivered' => 'bg-green-100 text-green-800',
                                        'failed' => 'bg-red-100 text-red-800',
                                        'returned' => 'bg-gray-100 text-gray-800',
                                    ];
                                    $color = $statusColors[$shipment->status] ?? 'bg-gray-100 text-gray-800';
                                @endphp
                                <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $color }}">
                                    {{ ucfirst(str_replace('_', ' ', $shipment->status)) }}
                                </span>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="text-sm text-gray-900">{{ $shipment->created_at->format('M d, Y') }}</div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm font-medium">
                                <a href="{{ route('admin.parcels.show', $shipment->id) }}" class="text-blue-600 hover:text-blue-900">
                                    <i class="fas fa-eye"></i> Track
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-4 py-8 text-center text-gray-500">
                                <i class="fas fa-shipping-fast fa-3x mb-3 text-gray-300"></i>
                                <p>No shipments found.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
