@extends('layouts.admin')

@section('title', 'Edit Discount')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Edit Discount</h1>
        <p class="text-sm text-gray-600">Updating: {{ $discount->name }} ({{ $discount->code }})</p>
    </div>

    @if ($errors->any())
        <div class="mb-4 p-3 bg-red-50 border border-red-200 text-red-700 rounded">
            <p class="font-semibold mb-1">There were validation errors:</p>
            <ul class="list-disc ml-5 text-sm">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('admin.marketing.rates.discounts.update', $discount) }}" class="bg-white border border-gray-200 rounded-lg p-6 space-y-4">
        @csrf
        @method('PUT')
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="form-label">Name</label>
                <input type="text" name="name" value="{{ old('name', $discount->name) }}" class="form-input" required>
            </div>
            <div>
                <label class="form-label">Code</label>
                <input type="text" name="code" value="{{ old('code', $discount->code) }}" class="form-input" required>
            </div>
            <div>
                <label class="form-label">Type</label>
                <select name="type" class="form-select" required>
                    @foreach(['percentage','fixed'] as $t)
                        <option value="{{ $t }}" @selected(old('type', $discount->type)===$t)>{{ ucfirst($t) }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="form-label">Amount</label>
                <input type="number" step="0.01" name="amount" value="{{ old('amount', $discount->amount) }}" class="form-input" required>
            </div>
            <div>
                <label class="form-label">Currency</label>
                <input type="text" name="currency" value="{{ old('currency', $discount->currency) }}" class="form-input" maxlength="3">
            </div>
            <div>
                <label class="form-label">Applies To</label>
                <select name="applies_to" class="form-select" required>
                    @foreach(['global','zone','merchant','service'] as $a)
                        <option value="{{ $a }}" @selected(old('applies_to', $discount->applies_to)===$a)>{{ ucfirst($a) }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="form-label">Target Code</label>
                <input type="text" name="target_code" value="{{ old('target_code', $discount->target_code) }}" class="form-input" placeholder="Zone/merchant/service code">
            </div>
            <div>
                <label class="form-label">Min Order Value</label>
                <input type="number" step="0.01" name="min_order_value" value="{{ old('min_order_value', $discount->min_order_value) }}" class="form-input">
            </div>
            <div>
                <label class="form-label">Max Discount Value</label>
                <input type="number" step="0.01" name="max_discount_value" value="{{ old('max_discount_value', $discount->max_discount_value) }}" class="form-input">
            </div>
            <div>
                <label class="form-label">Effective From</label>
                <input type="date" name="effective_from" value="{{ old('effective_from', optional($discount->effective_from)->format('Y-m-d')) }}" class="form-input">
            </div>
            <div>
                <label class="form-label">Effective To</label>
                <input type="date" name="effective_to" value="{{ old('effective_to', optional($discount->effective_to)->format('Y-m-d')) }}" class="form-input">
            </div>
            <div>
                <label class="form-label">Status</label>
                <select name="status" class="form-select" required>
                    @foreach(['active','inactive','archived'] as $s)
                        <option value="{{ $s }}" @selected(old('status', $discount->status)===$s)>{{ ucfirst($s) }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div>
            <label class="form-label">Notes</label>
            <textarea name="notes" rows="3" class="form-textarea">{{ old('notes', $discount->notes) }}</textarea>
        </div>
        <div class="flex items-center space-x-3">
            <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update Discount</button>
            <a href="{{ route('admin.marketing.rates.discounts.index') }}" class="px-3 sm:px-4 py-2 border border-gray-300 rounded-md text-xs sm:text-sm font-semibold text-gray-700 hover:bg-gray-50 transition">Cancel</a>
        </div>
    </form>
</div>
@endsection

