@extends('layouts.admin')

@section('title', 'Discount Management')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Discount Management</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage discounts and promotions</p>
        </div>
        <a href="{{ route('admin.marketing.rates.discounts.create') }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
            Add Discount
        </a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 mb-4">
        <form method="GET" action="{{ route('admin.marketing.rates.discounts.index') }}" class="grid grid-cols-1 md:grid-cols-5 gap-3">
            <input type="text" name="q" value="{{ request('q') }}" placeholder="Search name/code/target" class="form-input">
            <select name="status" class="form-select">
                <option value="">All Status</option>
                @foreach(['active','inactive','archived'] as $s)
                    <option value="{{ $s }}" @selected(request('status')===$s)>{{ ucfirst($s) }}</option>
                @endforeach
            </select>
            <select name="type" class="form-select">
                <option value="">All Types</option>
                @foreach(['percentage','fixed'] as $t)
                    <option value="{{ $t }}" @selected(request('type')===$t)>{{ ucfirst($t) }}</option>
                @endforeach
            </select>
            <select name="applies_to" class="form-select">
                <option value="">Applies To</option>
                @foreach(['global','zone','merchant','service'] as $a)
                    <option value="{{ $a }}" @selected(request('applies_to')===$a)>{{ ucfirst($a) }}</option>
                @endforeach
            </select>
            <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded-md">Filter</button>
        </form>
    </div>

    <div class="bg-white rounded-lg border border-gray-200 overflow-x-auto">
        <table class="min-w-full text-sm">
            <thead>
                <tr class="bg-gray-50 text-gray-600">
                    <th class="px-4 py-2 text-left">Name</th>
                    <th class="px-4 py-2 text-left">Code</th>
                    <th class="px-4 py-2">Type</th>
                    <th class="px-4 py-2">Amount</th>
                    <th class="px-4 py-2">Applies To</th>
                    <th class="px-4 py-2">Status</th>
                    <th class="px-4 py-2">Effective</th>
                    <th class="px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                @forelse($discounts as $discount)
                <tr>
                    <td class="px-4 py-2">
                        <a href="{{ route('admin.marketing.rates.discounts.show', $discount) }}" class="text-blue-600 hover:underline">{{ $discount->name }}</a>
                    </td>
                    <td class="px-4 py-2">{{ $discount->code }}</td>
                    <td class="px-4 py-2">{{ ucfirst($discount->type) }}</td>
                    <td class="px-4 py-2">{{ $discount->type==='percentage' ? $discount->amount.'%' : number_format($discount->amount,2).' '.$discount->currency }}</td>
                    <td class="px-4 py-2">{{ ucfirst($discount->applies_to) }} @if($discount->target_code) <span class="text-gray-400">({{ $discount->target_code }})</span>@endif</td>
                    <td class="px-4 py-2"><span class="px-2 py-1 rounded text-xs bg-gray-100">{{ ucfirst($discount->status) }}</span></td>
                    <td class="px-4 py-2">{{ optional($discount->effective_from)->format('Y-m-d') }} — {{ optional($discount->effective_to)->format('Y-m-d') }}</td>
                    <td class="px-4 py-2">
                        <a href="{{ route('admin.marketing.rates.discounts.edit', $discount) }}" class="text-indigo-600 hover:underline">Edit</a>
                        <form method="POST" action="{{ route('admin.marketing.rates.discounts.destroy', $discount) }}" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:underline ml-3" onclick="return confirm('Delete this discount?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="px-4 py-6 text-center text-gray-500">No discounts found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
        <div class="p-3 border-t">
            {{ $discounts->links() }}
        </div>
    </div>
</div>
@endsection


