@extends('layouts.admin')

@section('title', 'Discount Details')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">{{ $discount->name }}</h1>
            <p class="text-sm text-gray-600">Code: {{ $discount->code }}</p>
        </div>
        <div class="space-x-2">
            <a href="{{ route('admin.marketing.rates.discounts.edit', $discount) }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Edit</a>
            <a href="{{ route('admin.marketing.rates.discounts.index') }}" class="px-3 sm:px-4 py-2 border border-gray-300 rounded-md text-xs sm:text-sm font-semibold text-gray-700 hover:bg-gray-50 transition">Back</a>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="bg-white border border-gray-200 rounded-lg p-6">
            <h2 class="text-lg font-semibold mb-4">Discount Info</h2>
            <dl class="space-y-3 text-sm">
                <div class="flex justify-between">
                    <dt class="text-gray-500">Type</dt>
                    <dd class="text-gray-900">{{ ucfirst($discount->type) }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Amount</dt>
                    <dd class="text-gray-900">{{ $discount->type==='percentage' ? $discount->amount.'%' : number_format($discount->amount,2).' '.$discount->currency }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Applies To</dt>
                    <dd class="text-gray-900">{{ ucfirst($discount->applies_to) }}</dd>
                </div>
                @if($discount->target_code)
                <div class="flex justify-between">
                    <dt class="text-gray-500">Target Code</dt>
                    <dd class="text-gray-900">{{ $discount->target_code }}</dd>
                </div>
                @endif
                <div class="flex justify-between">
                    <dt class="text-gray-500">Min Order Value</dt>
                    <dd class="text-gray-900">{{ $discount->min_order_value ? number_format($discount->min_order_value,2).' '.$discount->currency : '—' }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Max Discount Value</dt>
                    <dd class="text-gray-900">{{ $discount->max_discount_value ? number_format($discount->max_discount_value,2).' '.$discount->currency : '—' }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Effective Dates</dt>
                    <dd class="text-gray-900">{{ optional($discount->effective_from)->format('Y-m-d') }} — {{ optional($discount->effective_to)->format('Y-m-d') }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Status</dt>
                    <dd class="text-gray-900">{{ ucfirst($discount->status) }}</dd>
                </div>
            </dl>
        </div>

        <div class="bg-white border border-gray-200 rounded-lg p-6">
            <h2 class="text-lg font-semibold mb-4">Notes</h2>
            <div class="prose max-w-none">
                <p class="text-gray-700">{{ $discount->notes ?? 'No notes provided.' }}</p>
            </div>
        </div>
    </div>

    <div class="mt-6 bg-white border border-gray-200 rounded-lg p-6">
        <h2 class="text-lg font-semibold mb-4">Quick Actions</h2>
        <div class="flex items-center space-x-3">
            <a href="{{ route('admin.marketing.rates.discounts.edit', $discount) }}" class="px-3 py-2 bg-indigo-600 text-white rounded">Edit Discount</a>
            <form method="POST" action="{{ route('admin.marketing.rates.discounts.destroy', $discount) }}">
                @csrf
                @method('DELETE')
                <button type="submit" class="px-3 py-2 bg-red-600 text-white rounded" onclick="return confirm('Delete this discount?')">Delete</button>
            </form>
        </div>
    </div>
</div>
@endsection

