@extends('layouts.admin')

@section('content')
<div class="p-6">
    <h1 class="text-xl sm:text-2xl lg:text-3xl font-semibold mb-4">Add Pricing Rate</h1>
    <div class="bg-white rounded border p-6">
        <form method="POST" action="{{ route('admin.marketing.rates.pricing.store') }}" class="space-y-4">
            @csrf
            @if ($errors->any())
                <div class="p-3 bg-red-50 border border-red-200 rounded text-red-700">
                    <div class="font-medium">Please fix the errors below:</div>
                    <ul class="mt-2 list-disc list-inside">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium">Name</label>
                    <input name="name" value="{{ old('name') }}" class="mt-1 w-full border rounded px-3 py-2" required />
                    @error('name')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Code</label>
                    <input name="code" value="{{ old('code') }}" class="mt-1 w-full border rounded px-3 py-2" required />
                    @error('code')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Currency</label>
                    <input name="currency" value="{{ old('currency', 'INR') }}" class="mt-1 w-full border rounded px-3 py-2" required />
                    @error('currency')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Zone</label>
                    <input name="zone" value="{{ old('zone') }}" class="mt-1 w-full border rounded px-3 py-2" />
                    @error('zone')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium">Base Rate</label>
                    <input type="number" step="0.01" name="base_rate" value="{{ old('base_rate') }}" class="mt-1 w-full border rounded px-3 py-2" required />
                    @error('base_rate')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Per KG Rate</label>
                    <input type="number" step="0.01" name="per_kg_rate" value="{{ old('per_kg_rate') }}" class="mt-1 w-full border rounded px-3 py-2" />
                    @error('per_kg_rate')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text sm font-medium">Per KM Rate</label>
                    <input type="number" step="0.01" name="per_km_rate" value="{{ old('per_km_rate') }}" class="mt-1 w-full border rounded px-3 py-2" />
                    @error('per_km_rate')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Minimum Charge</label>
                    <input type="number" step="0.01" name="min_charge" value="{{ old('min_charge') }}" class="mt-1 w-full border rounded px-3 py-2" />
                    @error('min_charge')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium">Effective From</label>
                    <input type="date" name="effective_from" value="{{ old('effective_from') }}" class="mt-1 w-full border rounded px-3 py-2" required />
                    @error('effective_from')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Effective To</label>
                    <input type="date" name="effective_to" value="{{ old('effective_to') }}" class="mt-1 w-full border rounded px-3 py-2" />
                    @error('effective_to')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium">Status</label>
                @php($statusOld = old('status', 'draft'))
                <select name="status" class="mt-1 w-full border rounded px-3 py-2" required>
                    @foreach(['draft','active','expired','archived'] as $st)
                        <option value="{{ $st }}" {{ $statusOld===$st ? 'selected' : '' }}>{{ ucfirst($st) }}</option>
                    @endforeach
                </select>
                @error('status')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
            </div>

            <div>
                <label class="block text-sm font-medium">Notes</label>
                <textarea name="notes" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" rows="4">{{ old('notes') }}</textarea>
                @error('notes')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
            </div>

            <div>
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save</button>
                <a href="{{ route('admin.marketing.rates.pricing.index') }}" class="ml-2 px-4 py-2 border rounded">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection
