@extends('layouts.admin')

@section('content')
<div class="p-6">
    <div class="flex justify-between items-center mb-4">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-semibold">Pricing Rates</h1>
        <a href="{{ route('admin.marketing.rates.pricing.create') }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add Rate</a>
    </div>

    <form method="GET" class="mb-4 grid grid-cols-1 md:grid-cols-4 gap-3">
        <input type="text" name="q" value="{{ request('q') }}" placeholder="Search name/code/zone/currency" class="border rounded px-3 py-2" />
        <select name="status" class="border rounded px-3 py-2">
            <option value="">All Status</option>
            @foreach(['draft','active','expired','archived'] as $st)
                <option value="{{ $st }}" {{ request('status')===$st ? 'selected' : '' }}>{{ ucfirst($st) }}</option>
            @endforeach
        </select>
        <input type="text" name="zone" value="{{ request('zone') }}" placeholder="Zone" class="border rounded px-3 py-2" />
        <button class="px-4 py-2 bg-gray-700 text-white rounded">Filter</button>
    </form>

    @if(session('success'))
        <div class="mb-3 p-3 bg-green-50 border border-green-200 rounded text-green-700">{{ session('success') }}</div>
    @endif

    <div class="overflow-x-auto bg-white rounded border">
        <table class="min-w-full">
            <thead>
                <tr class="border-b">
                    <th class="text-left p-2">Name</th>
                    <th class="text-left p-2">Code</th>
                    <th class="text-left p-2">Currency</th>
                    <th class="text-left p-2">Base</th>
                    <th class="text-left p-2">Per KG</th>
                    <th class="text-left p-2">Per KM</th>
                    <th class="text-left p-2">Zone</th>
                    <th class="text-left p-2">Effective</th>
                    <th class="text-left p-2">Status</th>
                    <th class="text-left p-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($pricings as $pricing)
                <tr class="border-b">
                    <td class="p-2">{{ $pricing->name }}</td>
                    <td class="p-2">{{ $pricing->code }}</td>
                    <td class="p-2">{{ $pricing->currency }}</td>
                    <td class="p-2">{{ number_format($pricing->base_rate,2) }}</td>
                    <td class="p-2">{{ $pricing->per_kg_rate ? number_format($pricing->per_kg_rate,2) : '-' }}</td>
                    <td class="p-2">{{ $pricing->per_km_rate ? number_format($pricing->per_km_rate,2) : '-' }}</td>
                    <td class="p-2">{{ $pricing->zone ?: '-' }}</td>
                    <td class="p-2">{{ $pricing->effective_from->format('Y-m-d') }}{{ $pricing->effective_to ? ' to '.$pricing->effective_to->format('Y-m-d') : '' }}</td>
                    <td class="p-2"><span class="px-2 py-1 text-xs rounded bg-gray-100">{{ ucfirst($pricing->status) }}</span></td>
                    <td class="p-2 space-x-2">
                        <a href="{{ route('admin.marketing.rates.pricing.show', $pricing) }}" class="text-blue-600">View</a>
                        <a href="{{ route('admin.marketing.rates.pricing.edit', $pricing) }}" class="text-indigo-600">Edit</a>
                        <form action="{{ route('admin.marketing.rates.pricing.destroy', $pricing) }}" method="POST" class="inline">
                            @csrf @method('DELETE')
                            <button onclick="return confirm('Delete this rate?')" class="text-red-600">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="10" class="p-4 text-center text-gray-500">No pricing rates found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">{{ $pricings->links() }}</div>
</div>
@endsection
