@extends('layouts.admin')

@section('content')
<div class="p-6">
    <div class="flex justify-between items-center mb-4">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-semibold">Pricing: {{ $pricing->name }}</h1>
        <div class="space-x-2">
            <a href="{{ route('admin.marketing.rates.pricing.edit', $pricing) }}" class="px-4 py-2 bg-indigo-600 text-white rounded">Edit</a>
            <a href="{{ route('admin.marketing.rates.pricing.index') }}" class="px-4 py-2 border rounded">Back</a>
        </div>
    </div>

    <div class="bg-white rounded border p-6 grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
            <div class="text-gray-500">Name</div>
            <div class="font-medium">{{ $pricing->name }}</div>
        </div>
        <div>
            <div class="text-gray-500">Code</div>
            <div class="font-medium">{{ $pricing->code }}</div>
        </div>
        <div>
            <div class="text-gray-500">Currency</div>
            <div class="font-medium">{{ $pricing->currency }}</div>
        </div>
        <div>
            <div class="text-gray-500">Zone</div>
            <div class="font-medium">{{ $pricing->zone ?: '-' }}</div>
        </div>
        <div>
            <div class="text-gray-500">Base Rate</div>
            <div class="font-medium">{{ number_format($pricing->base_rate,2) }}</div>
        </div>
        <div>
            <div class="text-gray-500">Per KG Rate</div>
            <div class="font-medium">{{ $pricing->per_kg_rate ? number_format($pricing->per_kg_rate,2) : '-' }}</div>
        </div>
        <div>
            <div class="text-gray-500">Per KM Rate</div>
            <div class="font-medium">{{ $pricing->per_km_rate ? number_format($pricing->per_km_rate,2) : '-' }}</div>
        </div>
        <div>
            <div class="text-gray-500">Minimum Charge</div>
            <div class="font-medium">{{ $pricing->min_charge ? number_format($pricing->min_charge,2) : '-' }}</div>
        </div>
        <div class="md:col-span-2">
            <div class="text-gray-500">Effective</div>
            <div class="font-medium">{{ $pricing->effective_from->format('Y-m-d') }}{{ $pricing->effective_to ? ' to '.$pricing->effective_to->format('Y-m-d') : '' }}</div>
        </div>
        <div>
            <div class="text-gray-500">Status</div>
            <div class="font-medium">{{ ucfirst($pricing->status) }}</div>
        </div>
        <div class="md:col-span-2">
            <div class="text-gray-500">Notes</div>
            <div class="font-medium whitespace-pre-line">{{ $pricing->notes }}</div>
        </div>
    </div>
</div>
@endsection
