@extends('layouts.admin')

@section('title', 'Add Zone Rate')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold mb-4">Add Zone Rate</h1>
    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <form method="POST" action="{{ route('admin.marketing.rates.zones.store') }}" class="space-y-4">
            @csrf
            @if ($errors->any())
                <div class="p-3 bg-red-50 border border-red-200 rounded text-red-700">
                    <div class="font-medium">Please fix the errors below:</div>
                    <ul class="mt-2 list-disc list-inside">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium">Name</label>
                    <input name="name" value="{{ old('name') }}" class="mt-1 w-full form-input" required />
                    @error('name')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Code</label>
                    <input name="code" value="{{ old('code') }}" class="mt-1 w-full form-input" required />
                    @error('code')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Zone</label>
                    <input name="zone" value="{{ old('zone') }}" class="mt-1 w-full form-input" required />
                    @error('zone')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Currency</label>
                    <input name="currency" value="{{ old('currency', 'USD') }}" class="mt-1 w-full form-input" required />
                    @error('currency')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Base Rate</label>
                    <input type="number" step="0.01" name="base_rate" value="{{ old('base_rate') }}" class="mt-1 w-full form-input" required />
                    @error('base_rate')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Additional per KG</label>
                    <input type="number" step="0.01" name="additional_per_kg" value="{{ old('additional_per_kg') }}" class="mt-1 w-full form-input" />
                    @error('additional_per_kg')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Remote Area Fee</label>
                    <input type="number" step="0.01" name="remote_area_fee" value="{{ old('remote_area_fee') }}" class="mt-1 w-full form-input" />
                    @error('remote_area_fee')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Fuel Surcharge (%)</label>
                    <input type="number" step="0.01" name="fuel_surcharge_percent" value="{{ old('fuel_surcharge_percent') }}" class="mt-1 w-full form-input" />
                    @error('fuel_surcharge_percent')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Effective From</label>
                    <input type="date" name="effective_from" value="{{ old('effective_from') }}" class="mt-1 w-full form-input" />
                    @error('effective_from')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Effective To</label>
                    <input type="date" name="effective_to" value="{{ old('effective_to') }}" class="mt-1 w-full form-input" />
                    @error('effective_to')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
                <div>
                    <label class="block text-sm font-medium">Status</label>
                    <select name="status" class="mt-1 w-full form-select" required>
                        @foreach(['active','inactive','archived'] as $s)
                            <option value="{{ $s }}" @selected(old('status')===$s)>{{ ucfirst($s) }}</option>
                        @endforeach
                    </select>
                    @error('status')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium">Notes</label>
                <textarea name="notes" class="mt-1 w-full form-textarea" rows="3">{{ old('notes') }}</textarea>
                @error('notes')<div class="text-red-600 text-sm">{{ $message }}</div>@enderror
            </div>

            <div class="flex gap-2 sm:gap-3">
                <button class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save</button>
                <a href="{{ route('admin.marketing.rates.zones.index') }}" class="px-3 sm:px-4 py-2 border border-gray-300 rounded-md text-xs sm:text-sm font-semibold text-gray-700 hover:bg-gray-50 transition">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection

