@extends('layouts.admin')

@section('title', 'Zone-based Rates')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Zone-based Rates</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage delivery rates by zone</p>
        </div>
        <a href="{{ route('admin.marketing.rates.zones.create') }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
            Add Zone Rate
        </a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 mb-4">
        <form method="GET" action="{{ route('admin.marketing.rates.zones.index') }}" class="grid grid-cols-1 md:grid-cols-5 gap-3">
            <input type="text" name="q" value="{{ request('q') }}" placeholder="Search name/code/zone" class="form-input">
            <input type="text" name="zone" value="{{ request('zone') }}" placeholder="Zone" class="form-input">
            <input type="text" name="currency" value="{{ request('currency') }}" placeholder="Currency" class="form-input">
            <select name="status" class="form-select">
                <option value="">All Status</option>
                @foreach(['active','inactive','archived'] as $s)
                    <option value="{{ $s }}" @selected(request('status')===$s)>{{ ucfirst($s) }}</option>
                @endforeach
            </select>
            <button class="px-4 py-2 bg-gray-700 text-white rounded-md">Filter</button>
        </form>
    </div>

    @if(session('status'))
        <div class="mb-3 p-3 bg-green-50 border border-green-200 rounded text-green-700">{{ session('status') }}</div>
    @endif

    <div class="overflow-x-auto bg-white rounded-lg border">
        <table class="min-w-full">
            <thead>
                <tr class="border-b text-left">
                    <th class="px-4 py-2">Name</th>
                    <th class="px-4 py-2">Code</th>
                    <th class="px-4 py-2">Zone</th>
                    <th class="px-4 py-2">Currency</th>
                    <th class="px-4 py-2">Base Rate</th>
                    <th class="px-4 py-2">Per KG</th>
                    <th class="px-4 py-2">Remote Fee</th>
                    <th class="px-4 py-2">Fuel %</th>
                    <th class="px-4 py-2">Status</th>
                    <th class="px-4 py-2">Effective</th>
                    <th class="px-4 py-2"></th>
                </tr>
            </thead>
            <tbody>
                @forelse($zones as $zone)
                <tr class="border-b">
                    <td class="px-4 py-2">
                        <a href="{{ route('admin.marketing.rates.zones.show', $zone) }}" class="text-blue-600 hover:underline">{{ $zone->name }}</a>
                    </td>
                    <td class="px-4 py-2">{{ $zone->code }}</td>
                    <td class="px-4 py-2">{{ $zone->zone }}</td>
                    <td class="px-4 py-2">{{ $zone->currency }}</td>
                    <td class="px-4 py-2">{{ number_format($zone->base_rate,2) }}</td>
                    <td class="px-4 py-2">{{ number_format($zone->additional_per_kg,2) }}</td>
                    <td class="px-4 py-2">{{ $zone->remote_area_fee !== null ? number_format($zone->remote_area_fee,2) : '-' }}</td>
                    <td class="px-4 py-2">{{ number_format($zone->fuel_surcharge_percent,2) }}%</td>
                    <td class="px-4 py-2"><span class="px-2 py-1 rounded text-xs bg-gray-100">{{ ucfirst($zone->status) }}</span></td>
                    <td class="px-4 py-2">{{ optional($zone->effective_from)->format('Y-m-d') }} — {{ optional($zone->effective_to)->format('Y-m-d') }}</td>
                    <td class="px-4 py-2">
                        <a href="{{ route('admin.marketing.rates.zones.edit', $zone) }}" class="text-indigo-600 hover:underline">Edit</a>
                        <form method="POST" action="{{ route('admin.marketing.rates.zones.destroy', $zone) }}" class="inline">
                            @csrf
                            @method('DELETE')
                            <button onclick="return confirm('Delete this zone rate?')" class="text-red-600 hover:underline">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="11" class="px-4 py-4 text-center text-gray-500">No zone rates found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">{{ $zones->links() }}</div>
</div>
@endsection


