@extends('layouts.admin')

@section('title', 'Zone Rate Details')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">{{ $zone->name }}</h1>
            <p class="text-sm text-gray-600">Code: {{ $zone->code }}</p>
        </div>
        <div class="space-x-2">
            <a href="{{ route('admin.marketing.rates.zones.edit', $zone) }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Edit</a>
            <a href="{{ route('admin.marketing.rates.zones.index') }}" class="px-3 sm:px-4 py-2 border border-gray-300 rounded-md text-xs sm:text-sm font-semibold text-gray-700 hover:bg-gray-50 transition">Back</a>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="bg-white border border-gray-200 rounded-lg p-6">
            <h2 class="text-lg font-semibold mb-4">Rate Info</h2>
            <dl class="space-y-3 text-sm">
                <div class="flex justify-between">
                    <dt class="text-gray-500">Zone</dt>
                    <dd class="text-gray-900">{{ $zone->zone }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Currency</dt>
                    <dd class="text-gray-900">{{ $zone->currency }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Base Rate</dt>
                    <dd class="text-gray-900">{{ number_format($zone->base_rate, 2) }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Additional per KG</dt>
                    <dd class="text-gray-900">{{ number_format($zone->additional_per_kg, 2) }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Remote Area Fee</dt>
                    <dd class="text-gray-900">{{ $zone->remote_area_fee !== null ? number_format($zone->remote_area_fee, 2) : '-' }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Fuel Surcharge (%)</dt>
                    <dd class="text-gray-900">{{ number_format($zone->fuel_surcharge_percent, 2) }}%</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Status</dt>
                    <dd class="text-gray-900">{{ ucfirst($zone->status) }}</dd>
                </div>
                <div class="flex justify-between">
                    <dt class="text-gray-500">Effective Period</dt>
                    <dd class="text-gray-900">{{ optional($zone->effective_from)->format('Y-m-d') }} — {{ optional($zone->effective_to)->format('Y-m-d') }}</dd>
                </div>
            </dl>
        </div>
        <div class="bg-white border border-gray-200 rounded-lg p-6">
            <h2 class="text-lg font-semibold mb-4">Notes</h2>
            <div class="prose prose-sm max-w-none text-gray-700">
                {{ $zone->notes ?: 'No notes.' }}
            </div>
        </div>
    </div>
</div>
@endsection

