@extends('layouts.admin')

@section('content')
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Add New Territory</h3>
  </div>
  <div class="card-body">
    <form action="{{ route('admin.marketing.territories.store') }}" method="POST">
      @csrf
      <div class="mb-3">
        <label for="name" class="form-label">Territory Name</label>
        <input type="text" class="form-control" id="name" name="name" required>
      </div>
      <div class="mb-3">
        <label for="user_id" class="form-label">Manager</label>
        <select class="form-select" id="user_id" name="user_id" required>
          @foreach (\App\Models\User::all() as $user)
            <option value="{{ $user->id }}">{{ $user->name }}</option>
          @endforeach
        </select>
      </div>
      <button type="submit" class="btn btn-primary">Add Territory</button>
    </form>
  </div>
</div>
@endsection
