@extends('layouts.admin')

@section('title', 'Territory Mapping')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Territory Mapping</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage sales territories and assign managers</p>
        </div>
        <button onclick="toggleAddTerritoryForm()" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
            <i class="fas fa-plus-circle me-1"></i>
            <span id="addTerritoryBtnText">Add Territory</span>
        </button>
    </div>

    <!-- Add Territory Form (Hidden by default) -->
    <div id="addTerritoryForm" class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 mb-4" style="display: none;">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Add New Territory</h2>
        <form action="{{ route('admin.marketing.territories.store') }}" method="POST">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="text-sm font-medium text-gray-700">Territory Name <span class="text-red-600">*</span></label>
                    <input type="text" name="name" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-700">Manager <span class="text-red-600">*</span></label>
                    <select name="user_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                        @foreach (\App\Models\User::all() as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="flex gap-2 mt-4">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-semibold hover:bg-blue-700 transition">
                    <i class="fas fa-save me-1"></i>
                    Save Territory
                </button>
                <button type="button" onclick="toggleAddTerritoryForm()" class="bg-gray-200 text-gray-800 px-4 py-2 rounded-md text-sm font-semibold hover:bg-gray-300 transition">
                    Cancel
                </button>
            </div>
        </form>
    </div>

    <!-- Territories Table -->
    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Territory Name</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Manager</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse ($territories as $territory)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ $territory->name }}</div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="text-sm text-gray-900">{{ $territory->manager->name }}</div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm font-medium">
                                <div class="flex items-center gap-2">
                                    <a href="{{ route('admin.marketing.territories.edit', $territory->id) }}" 
                                       class="text-blue-600 hover:text-blue-900">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <form action="{{ route('admin.marketing.territories.destroy', $territory->id) }}" 
                                          method="POST" 
                                          class="inline-block"
                                          onsubmit="return confirm('Are you sure you want to delete this territory?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:text-red-900">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="px-4 py-8 text-center text-gray-500">
                                <i class="fas fa-map-marked-alt fa-3x mb-3 text-gray-300"></i>
                                <p>No territories found. Add your first territory to get started.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function toggleAddTerritoryForm() {
    const form = document.getElementById('addTerritoryForm');
    const btnText = document.getElementById('addTerritoryBtnText');
    
    if (form.style.display === 'none') {
        form.style.display = 'block';
        btnText.textContent = 'Cancel';
        form.scrollIntoView({ behavior: 'smooth', block: 'start' });
    } else {
        form.style.display = 'none';
        btnText.textContent = 'Add Territory';
    }
}
</script>
@endsection
