@extends('layouts.admin')

@section('title', 'Create Sentiment Entry')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h1 class="text-2xl font-semibold mb-4">Create Sentiment Entry</h1>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form action="{{ route('admin.marketing.sentiment-tracking.store') }}" method="POST">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="merchant_id" class="block text-sm font-medium text-gray-700">Merchant</label>
                    <select id="merchant_id" name="merchant_id" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                        <option value="">Select a merchant</option>
                        @foreach($merchants as $merchant)
                            <option value="{{ $merchant->id }}">{{ $merchant->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label for="sentiment" class="block text-sm font-medium text-gray-700">Sentiment Score (-1 to 1)</label>
                    <input type="number" step="0.01" min="-1" max="1" id="sentiment" name="sentiment" class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                </div>

                <div>
                    <label for="source" class="block text-sm font-medium text-gray-700">Source</label>
                    <input type="text" id="source" name="source" placeholder="e.g., Email, Social Media, Survey" class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md">
                </div>

                <div class="md:col-span-2">
                    <label for="summary" class="block text-sm font-medium text-gray-700">Summary</label>
                    <textarea id="summary" name="summary" rows="4" class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md"></textarea>
                </div>
            </div>

            <div class="mt-6 flex justify-end">
                <a href="{{ route('admin.marketing.sentiment-tracking') }}" class="bg-gray-200 text-gray-800 px-4 py-2 rounded-md mr-2">Cancel</a>
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md">Save Entry</button>
            </div>
        </form>
    </div>
</div>
@endsection
