@extends('layouts.admin')

@section('title', 'Sentiment Tracking')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex justify-between items-center mb-4">
        <h1 class="text-2xl font-semibold">Sentiment Tracking</h1>
        <a href="{{ route('admin.marketing.sentiment-tracking.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded-md">Add New Entry</a>
    </div>

    @if(session('success'))
        <div class="bg-green-100 text-green-700 p-4 rounded-md mb-4">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow-md overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Merchant</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Sentiment</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Source</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Summary</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($sentiments as $sentiment)
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $sentiment->merchant->name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($sentiment->sentiment > 0.5)
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Positive ({{ $sentiment->sentiment }})</span>
                            @elseif($sentiment->sentiment < -0.5)
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Negative ({{ $sentiment->sentiment }})</span>
                            @else
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Neutral ({{ $sentiment->sentiment }})</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $sentiment->source }}</td>
                        <td class="px-6 py-4">{{ Str::limit($sentiment->summary, 50) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $sentiment->created_at->format('d M Y') }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <a href="{{ route('admin.marketing.sentiment-tracking.edit', $sentiment) }}" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                            <form action="{{ route('admin.marketing.sentiment-tracking.destroy', $sentiment) }}" method="POST" class="inline-block ml-4">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-900" onclick="return confirm('Are you sure you want to delete this entry?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-4 text-center text-gray-500">No sentiment entries found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $sentiments->links() }}
    </div>
</div>
@endsection

