@extends('layouts.admin')

@section('title', 'Edit Merchant - Admin')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6 max-w-4xl">
    <!-- Header -->
    <div class="mb-4 sm:mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Edit Merchant</h1>
                <p class="text-xs sm:text-sm text-gray-600 mt-1">Update merchant account information</p>
            </div>
            <a href="{{ route('admin.merchants.index') }}" class="bg-gray-600 text-white px-3 sm:px-4 py-2 rounded-md hover:bg-gray-700 text-xs sm:text-sm">
                Back to List
            </a>
        </div>
    </div>

    @if($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Whoops!</strong>
            <span class="block sm:inline">There were some problems with your input.</span>
            <ul class="mt-2 list-disc list-inside text-sm">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Form -->
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 lg:p-8">
        <form method="POST" action="{{ route('admin.merchants.update', $merchant) }}">
            @csrf
            @method('PUT')

            <!-- Personal Information -->
            <div class="mb-6">
                <h2 class="text-lg sm:text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Personal Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="name" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Full Name <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="name" id="name" value="{{ old('name', $merchant->name) }}" required
                               class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 {{ $errors->has('name') ? 'border-red-500' : '' }}">
                        @error('name')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="email" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Email Address <span class="text-red-500">*</span>
                        </label>
                        <input type="email" name="email" id="email" value="{{ old('email', $merchant->email) }}" required
                               class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 {{ $errors->has('email') ? 'border-red-500' : '' }}">
                        @error('email')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="phone" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Phone Number
                        </label>
                        <input type="text" name="phone" id="phone" value="{{ old('phone', $merchant->phone) }}"
                               placeholder="+92 300 1234567"
                               class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>

                    <div>
                        <label for="password" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Password <span class="text-xs text-gray-500">(Leave blank to keep current)</span>
                        </label>
                        <input type="password" name="password" id="password"
                               placeholder="Enter new password"
                               class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 {{ $errors->has('password') ? 'border-red-500' : '' }}">
                        @error('password')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                        <p class="mt-1 text-xs text-gray-500">Minimum 8 characters</p>
                    </div>
                </div>
            </div>

            <!-- Company Information -->
            <div class="mb-6">
                <h2 class="text-lg sm:text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Company Information</h2>
                <div class="grid grid-cols-1 gap-4">
                    <div>
                        <label for="company_name" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Company Name <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="company_name" id="company_name" value="{{ old('company_name', $merchant->company_name) }}" required
                               class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 {{ $errors->has('company_name') ? 'border-red-500' : '' }}">
                        @error('company_name')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Account Status -->
            <div class="mb-6">
                <h2 class="text-lg sm:text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Account Status</h2>
                <div class="bg-gray-50 p-4 rounded-md">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-700">Account Status</p>
                            <p class="text-xs text-gray-500">Current status of this merchant account</p>
                        </div>
                        <div>
                            @if($merchant->email_verified_at)
                                <span class="px-3 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                    Active
                                </span>
                            @else
                                <span class="px-3 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">
                                    Inactive
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="mt-3 text-xs text-gray-600">
                        <p><strong>Member Since:</strong> {{ $merchant->created_at->format('M d, Y') }}</p>
                        <p><strong>Last Updated:</strong> {{ $merchant->updated_at->format('M d, Y h:i A') }}</p>
                        @if($merchant->parcels)
                            <p><strong>Total Parcels:</strong> {{ $merchant->parcels->count() }}</p>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex flex-col sm:flex-row justify-end gap-3 pt-4 border-t">
                <a href="{{ route('admin.merchants.index') }}" 
                   class="px-6 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 text-center text-xs sm:text-sm">
                    Cancel
                </a>
                <button type="submit" 
                        class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
                    Update Merchant
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

