@extends('layouts.admin')

@section('title', 'Merchant Details - Admin')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <!-- Header -->
    <div class="mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-3">
            <div>
                <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Merchant Details</h1>
                <p class="text-xs sm:text-sm text-gray-600 mt-1">View complete merchant information and activity</p>
            </div>
            <div class="flex gap-2 w-full sm:w-auto">
                <a href="{{ route('admin.merchants.index') }}" class="flex-1 sm:flex-none bg-gray-600 text-white px-3 sm:px-4 py-2 rounded-md hover:bg-gray-700 text-xs sm:text-sm text-center">
                    Back to List
                </a>
                <a href="{{ route('admin.merchants.edit', $merchant) }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
                    Edit Merchant
                </a>
            </div>
        </div>
    </div>

    <!-- Merchant Info Card -->
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row items-start sm:items-center gap-4">
            <div class="h-16 w-16 sm:h-20 sm:w-20 rounded-full bg-blue-500 flex items-center justify-center flex-shrink-0">
                <span class="text-white font-bold text-2xl sm:text-3xl">{{ substr($merchant->name, 0, 1) }}</span>
            </div>
            <div class="flex-1">
                <h2 class="text-lg sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $merchant->name }}</h2>
                <p class="text-sm sm:text-base text-gray-600">{{ $merchant->company_name }}</p>
                <div class="flex flex-wrap gap-2 mt-2">
                    @if($merchant->email_verified_at)
                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                            Active
                        </span>
                    @else
                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">
                            Inactive
                        </span>
                    @endif
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                        Seller
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 lg:gap-6 mb-4 sm:mb-6">
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-blue-500 rounded-md p-2 sm:p-2.5 lg:p-3">
                    <svg class="h-4 w-4 sm:h-5 sm:w-5 lg:h-6 lg:w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                    </svg>
                </div>
                <div class="ml-2 sm:ml-3 lg:ml-4">
                    <p class="text-[10px] sm:text-xs lg:text-sm font-medium text-gray-600">Total Parcels</p>
                    <p class="text-base sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $parcelStats['total'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-yellow-500 rounded-md p-2 sm:p-2.5 lg:p-3">
                    <svg class="h-4 w-4 sm:h-5 sm:w-5 lg:h-6 lg:w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <div class="ml-2 sm:ml-3 lg:ml-4">
                    <p class="text-[10px] sm:text-xs lg:text-sm font-medium text-gray-600">Pending</p>
                    <p class="text-base sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $parcelStats['pending'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-green-500 rounded-md p-2 sm:p-2.5 lg:p-3">
                    <svg class="h-4 w-4 sm:h-5 sm:w-5 lg:h-6 lg:w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                </div>
                <div class="ml-2 sm:ml-3 lg:ml-4">
                    <p class="text-[10px] sm:text-xs lg:text-sm font-medium text-gray-600">Delivered</p>
                    <p class="text-base sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $parcelStats['delivered'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-red-500 rounded-md p-2 sm:p-2.5 lg:p-3">
                    <svg class="h-4 w-4 sm:h-5 sm:w-5 lg:h-6 lg:w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 15v-1a4 4 0 00-4-4H8m0 0l3 3m-3-3l3-3m9 14V5a2 2 0 00-2-2H6a2 2 0 00-2 2v16l4-2 4 2 4-2 4 2z"/>
                    </svg>
                </div>
                <div class="ml-2 sm:ml-3 lg:ml-4">
                    <p class="text-[10px] sm:text-xs lg:text-sm font-medium text-gray-600">Returned</p>
                    <p class="text-base sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $parcelStats['returned'] }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Contact Information -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 sm:gap-6 mb-4 sm:mb-6">
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
            <h3 class="text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Contact Information</h3>
            <div class="space-y-3">
                <div class="flex items-start">
                    <svg class="h-5 w-5 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                    <div>
                        <p class="text-xs text-gray-500">Email</p>
                        <p class="text-sm sm:text-base font-medium text-gray-900">{{ $merchant->email }}</p>
                    </div>
                </div>
                @if($merchant->phone)
                <div class="flex items-start">
                    <svg class="h-5 w-5 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                    </svg>
                    <div>
                        <p class="text-xs text-gray-500">Phone</p>
                        <p class="text-sm sm:text-base font-medium text-gray-900">{{ $merchant->phone }}</p>
                    </div>
                </div>
                @endif
                <div class="flex items-start">
                    <svg class="h-5 w-5 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                    </svg>
                    <div>
                        <p class="text-xs text-gray-500">Company</p>
                        <p class="text-sm sm:text-base font-medium text-gray-900">{{ $merchant->company_name }}</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
            <h3 class="text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Account Information</h3>
            <div class="space-y-3">
                <div class="flex items-start">
                    <svg class="h-5 w-5 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                    <div>
                        <p class="text-xs text-gray-500">Member Since</p>
                        <p class="text-sm sm:text-base font-medium text-gray-900">{{ $merchant->created_at->format('M d, Y') }}</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <svg class="h-5 w-5 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    <div>
                        <p class="text-xs text-gray-500">Last Updated</p>
                        <p class="text-sm sm:text-base font-medium text-gray-900">{{ $merchant->updated_at->format('M d, Y h:i A') }}</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <svg class="h-5 w-5 text-gray-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                    </svg>
                    <div>
                        <p class="text-xs text-gray-500">Account Type</p>
                        <p class="text-sm sm:text-base font-medium text-gray-900">{{ ucwords(str_replace('-', ' ', $merchant->role)) }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Parcels -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="p-4 sm:p-6 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <h3 class="text-base sm:text-lg font-semibold text-gray-800">Recent Parcels</h3>
                <a href="{{ route('admin.parcels.index', ['seller_id' => $merchant->id]) }}" class="text-xs sm:text-sm text-blue-600 hover:text-blue-800">
                    View All →
                </a>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-2 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Tracking ID
                        </th>
                        <th class="px-3 sm:px-6 py-2 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden sm:table-cell">
                            Recipient
                        </th>
                        <th class="px-3 sm:px-6 py-2 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden md:table-cell">
                            City
                        </th>
                        <th class="px-3 sm:px-6 py-2 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Status
                        </th>
                        <th class="px-3 sm:px-6 py-2 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden lg:table-cell">
                            Date
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($merchant->parcels as $parcel)
                    <tr class="hover:bg-gray-50">
                        <td class="px-3 sm:px-6 py-3 sm:py-4">
                            <a href="{{ route('admin.parcels.show', $parcel) }}" class="text-xs sm:text-sm font-medium text-blue-600 hover:text-blue-900">
                                {{ $parcel->tracking_id }}
                            </a>
                        </td>
                        <td class="px-3 sm:px-6 py-3 sm:py-4 text-xs sm:text-sm text-gray-900 hidden sm:table-cell">
                            {{ $parcel->recipient_name }}
                        </td>
                        <td class="px-3 sm:px-6 py-3 sm:py-4 text-xs sm:text-sm text-gray-900 hidden md:table-cell">
                            {{ $parcel->city }}
                        </td>
                        <td class="px-3 sm:px-6 py-3 sm:py-4">
                            <span class="px-2 inline-flex text-[10px] sm:text-xs leading-5 font-semibold rounded-full 
                                @if($parcel->status == 'Delivered') bg-green-100 text-green-800
                                @elseif($parcel->status == 'Pending') bg-yellow-100 text-yellow-800
                                @elseif($parcel->status == 'In Transit') bg-blue-100 text-blue-800
                                @else bg-gray-100 text-gray-800
                                @endif">
                                {{ $parcel->status }}
                            </span>
                        </td>
                        <td class="px-3 sm:px-6 py-3 sm:py-4 text-xs sm:text-sm text-gray-500 hidden lg:table-cell">
                            {{ $parcel->booking_date->format('M d, Y') }}
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                            </svg>
                            <p class="mt-4 text-sm">No parcels found for this merchant</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection


