@extends('layouts.admin')

@section('title', 'Edit Parcel - Admin')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6 max-w-4xl">
    <!-- Header -->
    <div class="mb-4 sm:mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900">Edit Parcel</h1>
                <p class="text-gray-600 mt-1">Update parcel information - {{ $parcel->tracking_id }}</p>
            </div>
            <a href="{{ route('admin.parcels.index') }}" class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700">
                Back to List
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
    @endif

    @if($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <ul class="list-disc list-inside">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Edit Form -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <form method="POST" action="{{ route('admin.parcels.update', $parcel) }}">
            @csrf
            @method('PUT')

            <!-- Tracking Information -->
            <div class="mb-4 sm:mb-6">
                <h2 class="text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Tracking Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Tracking ID</label>
                        <input type="text" value="{{ $parcel->tracking_id }}" disabled
                               class="w-full px-3 py-2 border border-gray-300 rounded-md bg-gray-100 text-gray-600">
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Status *</label>
                        <select name="status" required
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="Pending" {{ $parcel->status == 'Pending' ? 'selected' : '' }}>Pending</option>
                            <option value="Picked Up" {{ $parcel->status == 'Picked Up' ? 'selected' : '' }}>Picked Up</option>
                            <option value="In Transit" {{ $parcel->status == 'In Transit' ? 'selected' : '' }}>In Transit</option>
                            <option value="In Warehouse" {{ $parcel->status == 'In Warehouse' ? 'selected' : '' }}>In Warehouse</option>
                            <option value="Out for Delivery" {{ $parcel->status == 'Out for Delivery' ? 'selected' : '' }}>Out for Delivery</option>
                            <option value="Delivered" {{ $parcel->status == 'Delivered' ? 'selected' : '' }}>Delivered</option>
                            <option value="Failed" {{ $parcel->status == 'Failed' ? 'selected' : '' }}>Failed</option>
                            <option value="Returned" {{ $parcel->status == 'Returned' ? 'selected' : '' }}>Returned</option>
                            <option value="Attempted" {{ $parcel->status == 'Attempted' ? 'selected' : '' }}>Attempted</option>
                            <option value="Out for Return" {{ $parcel->status == 'Out for Return' ? 'selected' : '' }}>Out for Return</option>
                            <option value="Branch Shift" {{ $parcel->status == 'Branch Shift' ? 'selected' : '' }}>Branch Shift</option>
                            <option value="Cancelled" {{ $parcel->status == 'Cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Recipient Information -->
            <div class="mb-4 sm:mb-6">
                <h2 class="text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Recipient Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Recipient Name *</label>
                        <input type="text" name="recipient_name" value="{{ old('recipient_name', $parcel->recipient_name) }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Contact Number *</label>
                        <input type="text" name="contact" value="{{ old('contact', $parcel->contact) }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">City *</label>
                        <input type="text" name="city" value="{{ old('city', $parcel->city) }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Zone *</label>
                        <input type="text" name="zone" value="{{ old('zone', $parcel->zone) }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Delivery Address *</label>
                        <textarea name="address" rows="2" required
                                  class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('address', $parcel->address) }}</textarea>
                    </div>
                </div>
            </div>

            <!-- Order Details -->
            <div class="mb-4 sm:mb-6">
                <h2 class="text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Order Details</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">COD Amount *</label>
                        <input type="number" name="cod_amount" value="{{ old('cod_amount', $parcel->cod_amount) }}" step="0.01" min="0" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Seller</label>
                        <input type="text" value="{{ $parcel->seller->name }} ({{ $parcel->seller->company_name }})" disabled
                               class="w-full px-3 py-2 border border-gray-300 rounded-md bg-gray-100 text-gray-600">
                    </div>
                </div>
            </div>

            <!-- Assignment -->
            <div class="mb-4 sm:mb-6">
                <h2 class="text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Assignment</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Assigned Rider</label>
                        <select name="assigned_rider_id"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Unassigned</option>
                            @foreach($riders as $rider)
                                <option value="{{ $rider->id }}" {{ $parcel->assigned_rider_id == $rider->id ? 'selected' : '' }}>
                                    {{ $rider->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Booking Date</label>
                        <input type="text" value="{{ $parcel->booking_date->format('M d, Y') }}" disabled
                               class="w-full px-3 py-2 border border-gray-300 rounded-md bg-gray-100 text-gray-600">
                    </div>
                </div>
            </div>

            <!-- Notes -->
            <div class="mb-4 sm:mb-6">
                <h2 class="text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Additional Information</h2>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Notes</label>
                    <textarea name="notes" rows="3"
                              class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500"
                              placeholder="Add any additional notes or instructions...">{{ old('notes', $parcel->notes) }}</textarea>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex justify-end space-x-3 pt-4 border-t">
                <a href="{{ route('admin.parcels.index') }}" 
                   class="px-6 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">
                    Cancel
                </a>
                <button type="submit" 
                        class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
                    Update Parcel
                </button>
            </div>
        </form>
    </div>

    <!-- Parcel Details (Read-only) -->
    <div class="bg-white rounded-lg shadow-md p-6 mt-6">
        <h2 class="text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Additional Parcel Information (Read-only)</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
            <div>
                <p class="text-gray-600">Order Type</p>
                <p class="font-semibold text-gray-900">{{ $parcel->order_type ?? 'N/A' }}</p>
            </div>
            <div>
                <p class="text-gray-600">Order Reference</p>
                <p class="font-semibold text-gray-900">{{ $parcel->order_reference_number ?? 'N/A' }}</p>
            </div>
            <div>
                <p class="text-gray-600">Items Count</p>
                <p class="font-semibold text-gray-900">{{ $parcel->items ?? 'N/A' }}</p>
            </div>
            <div>
                <p class="text-gray-600">Booking Weight</p>
                <p class="font-semibold text-gray-900">{{ $parcel->booking_weight ?? 'N/A' }} kg</p>
            </div>
            <div>
                <p class="text-gray-600">Pickup City</p>
                <p class="font-semibold text-gray-900">{{ $parcel->pickup_city ?? 'N/A' }}</p>
            </div>
            <div>
                <p class="text-gray-600">Return City</p>
                <p class="font-semibold text-gray-900">{{ $parcel->return_city ?? 'N/A' }}</p>
            </div>
        </div>
        @if($parcel->order_detail)
            <div class="mt-4">
                <p class="text-gray-600 mb-1">Order Details</p>
                <p class="text-gray-900">{{ $parcel->order_detail }}</p>
            </div>
        @endif
    </div>
</div>
@endsection



