@extends('layouts.admin')

@section('title', 'Cash Collection')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Header -->
    <div class="mb-8 flex justify-between items-center">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Rider Cash Collection</h1>
            <p class="text-gray-600">Summary of COD collected from delivered parcels</p>
        </div>
        <a href="{{ route('admin.riders.profiles') }}" class="text-sm text-blue-600 hover:underline">Back to Profiles</a>
    </div>

    <!-- Stats -->
    @php
        $totalRidersWithCOD = $riders->count();
        $totalParcels = 0; $totalCOD = 0;
        foreach ($riders as $rider) {
            $totalParcels += $rider->parcels->count();
            $totalCOD += $rider->parcels->sum('cod_amount');
        }
    @endphp

    <div class="grid grid-cols-1 sm:grid-cols-3 gap-6 mb-8">
        <div class="bg-white rounded-lg shadow p-6">
            <p class="text-sm text-gray-600">Riders with COD</p>
            <p class="text-3xl font-bold text-gray-900">{{ $totalRidersWithCOD }}</p>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <p class="text-sm text-gray-600">Total Parcels</p>
            <p class="text-3xl font-bold text-indigo-600">{{ $totalParcels }}</p>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <p class="text-sm text-gray-600">Total COD</p>
            <p class="text-3xl font-bold text-green-600">Rs. {{ number_format($totalCOD, 2) }}</p>
        </div>
    </div>

    <!-- Riders COD Table -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="p-4 border-b">
            <h2 class="text-lg font-semibold">COD Collections by Rider</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Rider</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Phone</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Parcels</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Total COD</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Details</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($riders as $rider)
                        @php
                            $parcelCount = $rider->parcels->count();
                            $riderTotalCOD = $rider->parcels->sum('cod_amount');
                        @endphp
                        <tr>
                            <td class="px-6 py-4 text-sm text-gray-900">{{ $rider->name }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700">{{ $rider->phone }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700">{{ $parcelCount }}</td>
                            <td class="px-6 py-4 text-sm font-semibold text-green-700">Rs. {{ number_format($riderTotalCOD, 2) }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700">
                                @forelse($rider->parcels as $parcel)
                                    <span class="inline-block mr-2 mb-1 px-2 py-1 text-xs rounded bg-gray-100">#{{ $parcel->tracking_id ?? $parcel->id }} (Rs. {{ number_format($parcel->cod_amount, 2) }})</span>
                                @empty
                                    <span class="text-gray-400">No parcels</span>
                                @endforelse
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-10 text-gray-500">No COD collections found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
