@extends('layouts.admin')

@section('title', 'Pending COD')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Pending COD</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Parcels delivered with COD pending scan/collection</p>
        </div>
        <div class="space-x-2">
            <a href="{{ route('admin.riders.finance.cash-collection') }}" class="px-3 sm:px-4 py-1.5 sm:py-2 bg-gray-100 text-gray-700 rounded hover:bg-gray-200 text-xs sm:text-sm">Cash Collection</a>
            <a href="{{ route('admin.riders.finance.discrepancy') }}" class="px-3 sm:px-4 py-1.5 sm:py-2 bg-gray-100 text-gray-700 rounded hover:bg-gray-200 text-xs sm:text-sm">Discrepancy</a>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-3 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <div class="bg-white rounded-lg shadow p-4">
            <p class="text-[11px] text-gray-500">Pending Parcels</p>
            <p class="text-lg sm:text-xl font-semibold text-gray-900">{{ $pendingCOD->count() }}</p>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <p class="text-[11px] text-gray-500">Total Pending COD</p>
            <p class="text-lg sm:text-xl font-semibold text-gray-900">PKR {{ number_format($pendingCOD->sum('cod_amount'), 2) }}</p>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <p class="text-[11px] text-gray-500">Riders Involved</p>
            <p class="text-lg sm:text-xl font-semibold text-gray-900">{{ $pendingCOD->pluck('assigned_rider_id')->filter()->unique()->count() }}</p>
        </div>
    </div>

    <!-- Pending COD Table -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-4 sm:px-6 py-3 border-b border-gray-200">
            <h2 class="text-sm sm:text-base font-semibold text-gray-900">Parcels with Pending COD</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 sm:px-6 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Tracking ID</th>
                        <th class="px-4 sm:px-6 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Rider</th>
                        <th class="px-4 sm:px-6 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">City</th>
                        <th class="px-4 sm:px-6 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">COD Amount</th>
                        <th class="px-4 sm:px-6 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-4 sm:px-6 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Updated At</th>
                        <th class="px-4 sm:px-6 py-2 text-center text-[11px] font-medium text-gray-500 uppercase tracking-wider">Scanned</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($pendingCOD as $parcel)
                    <tr>
                        <td class="px-4 sm:px-6 py-2.5 whitespace-nowrap text-xs font-medium text-blue-600">{{ $parcel->tracking_id }}</td>
                        <td class="px-4 sm:px-6 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ optional($parcel->rider)->name ?? 'Unassigned' }}</td>
                        <td class="px-4 sm:px-6 py-2.5 whitespace-nowrap text-xs text-gray-700">{{ $parcel->city }}</td>
                        <td class="px-4 sm:px-6 py-2.5 whitespace-nowrap text-xs text-gray-900">PKR {{ number_format($parcel->cod_amount, 2) }}</td>
                        <td class="px-4 sm:px-6 py-2.5 whitespace-nowrap">
                            <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full 
                                @if($parcel->status === 'Delivered') bg-green-100 text-green-800
                                @elseif($parcel->status === 'Pending') bg-yellow-100 text-yellow-800
                                @elseif(in_array($parcel->status, ['In Transit', 'Picked Up', 'Out for Delivery'])) bg-blue-100 text-blue-800
                                @else bg-red-100 text-red-800
                                @endif">
                                {{ $parcel->status }}
                            </span>
                        </td>
                        <td class="px-4 sm:px-6 py-2.5 whitespace-nowrap text-xs text-gray-700">{{ optional($parcel->updated_at)->format('Y-m-d H:i') }}</td>
                        <td class="px-4 sm:px-6 py-2.5 whitespace-nowrap text-xs text-center">
                            @if($parcel->is_scanned)
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-green-100 text-green-800">Yes</span>
                            @else
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-red-100 text-red-800">No</span>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="px-6 py-6 text-center text-gray-500">No pending COD parcels found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
