@extends('layouts.admin')

@section('title', 'Assign Parcels to Riders')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Assign Parcels</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Assign available parcels to active riders.</p>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <form action="{{ route('admin.riders.assign-parcels.store') }}" method="POST">
            @csrf
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                {{-- Rider Selection --}}
                <div class="lg:col-span-1">
                    <label for="rider_id" class="block text-xs sm:text-sm font-medium text-gray-700">Select Rider</label>
                    <select id="rider_id" name="rider_id" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">-- Select a Rider --</option>
                        @foreach($riders as $rider)
                            <option value="{{ $rider->id }}">{{ $rider->name }} ({{ $rider->employee_id }})</option>
                        @endforeach
                    </select>
                </div>

                {{-- Parcel Selection --}}
                <div class="lg:col-span-2">
                    <h3 class="text-lg font-semibold mb-2">Available Parcels</h3>
                    <div class="overflow-auto border border-gray-200 rounded-md" style="max-height: 400px;">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><input type="checkbox" id="select-all-parcels"></th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tracking #</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Recipient</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Address</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($availableParcels as $parcel)
                                    <tr>
                                        <td class="px-4 py-2"><input type="checkbox" name="parcel_ids[]" value="{{ $parcel->id }}" class="parcel-checkbox"></td>
                                        <td class="px-4 py-2 text-sm">{{ $parcel->tracking_number }}</td>
                                        <td class="px-4 py-2 text-sm">{{ $parcel->recipient_name }}</td>
                                        <td class="px-4 py-2 text-sm">{{ $parcel->recipient_address }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center py-4 text-sm text-gray-500">No available parcels.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Assign Selected Parcels</button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
    document.getElementById('select-all-parcels').addEventListener('click', function(event) {
        const checkboxes = document.querySelectorAll('.parcel-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.checked = event.target.checked;
        });
    });
</script>
@endpush
@endsection



