@extends('layouts.admin')

@section('title', 'Rider Attendance')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Header -->
    <div class="mb-8 flex justify-between items-center">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Rider Attendance</h1>
            <p class="text-gray-600">Overview of rider duty status and recent activity</p>
        </div>
        <a href="{{ route('admin.riders.profiles') }}" class="text-sm text-blue-600 hover:underline">Back to Profiles</a>
    </div>

    <!-- Stats -->
    <div class="grid grid-cols-1 sm:grid-cols-3 gap-6 mb-8">
        <div class="bg-white rounded-lg shadow p-6">
            <p class="text-sm text-gray-600">Total Riders</p>
            <p class="text-3xl font-bold text-gray-900">{{ $totalRiders }}</p>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <p class="text-sm text-gray-600">On Duty</p>
            <p class="text-3xl font-bold text-green-600">{{ $onDutyCount }}</p>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <p class="text-sm text-gray-600">Available</p>
            <p class="text-3xl font-bold text-blue-600">{{ $availableCount }}</p>
        </div>
    </div>

    <!-- Riders Table -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="p-4 border-b">
            <h2 class="text-lg font-semibold">Rider Duty Status</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Name</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Phone</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Branch</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Recent Parcels</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($riders as $rider)
                        <tr>
                            <td class="px-6 py-4 text-sm text-gray-900">{{ $rider->name }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700">{{ $rider->phone }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700">{{ optional($rider->branch)->name ?? '—' }}</td>
                            <td class="px-6 py-4 text-sm">
                                @php $status = $rider->current_status; @endphp
                                <span class="px-2 py-1 text-xs rounded-full {{ $status === 'on_duty' ? 'bg-green-100 text-green-800' : 'bg-blue-100 text-blue-800' }}">
                                    {{ $status === 'on_duty' ? 'On Duty' : 'Available' }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-700">
                                @forelse($rider->parcels as $parcel)
                                    <span class="inline-block mr-2 mb-1 px-2 py-1 text-xs rounded bg-gray-100">#{{ $parcel->tracking_id ?? $parcel->id }} ({{ $parcel->status }})</span>
                                @empty
                                    <span class="text-gray-400">No recent activity</span>
                                @endforelse
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-10 text-gray-500">No riders found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4 border-t">
            {{ $riders->links() }}
        </div>
    </div>
 </div>
@endsection


