@extends('layouts.admin')

@section('title', 'Real-time GPS Tracking')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Real-time Rider Tracking</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Monitor rider locations and statuses in real-time.</p>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        {{-- Map View --}}
        <div class="lg:col-span-2 bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <h2 class="text-lg font-semibold mb-4">Live Map</h2>
            <div class="bg-gray-200 h-96 rounded-md flex items-center justify-center">
                <p class="text-gray-500">Interactive map will be displayed here.</p>
            </div>
        </div>

        {{-- Rider List --}}
        <div class="lg:col-span-1 bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <h2 class="text-lg font-semibold mb-4">Rider Status</h2>
            <ul class="divide-y divide-gray-200">
                @foreach($riders as $rider)
                    <li class="py-3 flex justify-between items-center">
                        <div>
                            <p class="text-sm font-medium text-gray-900">{{ $rider['name'] }}</p>
                            <p class="text-xs text-gray-500">Lat: {{ $rider['lat'] }}, Lng: {{ $rider['lng'] }}</p>
                        </div>
                        <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full {{ $rider['status'] === 'On-duty' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            {{ $rider['status'] }}
                        </span>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
</div>
@endsection



