@extends('layouts.admin')

@section('title', 'Create Rider')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Header -->
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Create New Rider</h1>
        <p class="text-gray-600">Add a new delivery rider to the system</p>
    </div>

    <!-- Create Form -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-6 border-b">
            <h3 class="text-lg font-semibold">Rider Information</h3>
        </div>
        <form action="{{ route('admin.riders.store') }}" method="POST" class="p-6">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-3 sm:gap-4 lg:gap-6 mb-4 sm:mb-6">
                <div>
                    <label for="name" class="block text-xs sm:text-sm font-medium text-gray-700 mb-2">Full Name *</label>
                    <input type="text" name="name" id="name" value="{{ old('name') }}"
                           class="form-input @error('name') border-red-500 @enderror" required>
                    @error('name')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="email" class="block text-xs sm:text-sm font-medium text-gray-700 mb-2">Email Address *</label>
                    <input type="email" name="email" id="email" value="{{ old('email') }}"
                           class="form-input @error('email') border-red-500 @enderror" required>
                    @error('email')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="phone" class="block text-xs sm:text-sm font-medium text-gray-700 mb-2">Phone Number *</label>
                    <input type="text" name="phone" id="phone" value="{{ old('phone') }}"
                           class="form-input @error('phone') border-red-500 @enderror" required>
                    @error('phone')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="license_number" class="block text-xs sm:text-sm font-medium text-gray-700 mb-2">License Number *</label>
                    <input type="text" name="license_number" id="license_number" value="{{ old('license_number') }}"
                           class="form-input @error('license_number') border-red-500 @enderror" required>
                    @error('license_number')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="vehicle_type" class="block text-xs sm:text-sm font-medium text-gray-700 mb-2">Vehicle Type *</label>
                    <select name="vehicle_type" id="vehicle_type"
                            class="form-input @error('vehicle_type') border-red-500 @enderror" required>
                        <option value="">Select Vehicle Type</option>
                        <option value="motorcycle" {{ old('vehicle_type') == 'motorcycle' ? 'selected' : '' }}>Motorcycle</option>
                        <option value="car" {{ old('vehicle_type') == 'car' ? 'selected' : '' }}>Car</option>
                        <option value="van" {{ old('vehicle_type') == 'van' ? 'selected' : '' }}>Van</option>
                        <option value="truck" {{ old('vehicle_type') == 'truck' ? 'selected' : '' }}>Truck</option>
                    </select>
                    @error('vehicle_type')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="status" class="block text-xs sm:text-sm font-medium text-gray-700 mb-2">Status *</label>
                    <select name="status" id="status"
                            class="form-input @error('status') border-red-500 @enderror" required>
                        <option value="">Select Status</option>
                        <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                    @error('status')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div class="flex justify-end space-x-4">
                <a href="{{ route('admin.riders.index') }}" class="btn-secondary">Cancel</a>
                <button type="submit" class="btn-primary">Create Rider</button>
            </div>
        </form>
    </div>
</div>
@endsection


