@extends('layouts.admin')

@section('title', 'Riders Management')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Riders Management</h1>
            <p class="text-sm text-gray-600">Manage all delivery riders and their assignments.</p>
        </div>
        <div>
            <a href="{{ route('admin.riders.create') }}" class="btn-primary">Add New Rider</a>
        </div>
    </div>

    <!-- Riders Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b">
            <h3 class="text-lg font-semibold">All Riders</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Name</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Phone</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Vehicle</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($riders as $rider)
                        <tr>
                            <td class="px-6 py-4 text-sm font-medium">{{ $rider->name }}</td>
                            <td class="px-6 py-4 text-sm">{{ $rider->phone }}</td>
                            <td class="px-6 py-4 text-sm">{{ $rider->vehicle_type }}</td>
                            <td class="px-6 py-4">
                                @if($rider->status === 'active')
                                    <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-green-100 text-green-800">Active</span>
                                @else
                                    <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-red-100 text-red-800">Inactive</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-sm">
                                <a href="{{ route('admin.riders.show', $rider) }}" class="text-indigo-600 hover:text-indigo-900">View</a>
                                <a href="{{ route('admin.riders.edit', $rider) }}" class="text-blue-600 hover:text-blue-900 ml-2">Edit</a>
                                <form action="{{ route('admin.riders.destroy', $rider) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900 ml-2">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-10">No riders found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $riders->links() }}</div>
    </div>
</div>
@endsection



