@extends('layouts.admin')

@section('title', 'Rider Details')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900">{{ $rider->name }}</h1>
                <p class="text-gray-600">Rider Information & Performance</p>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('admin.riders.edit', $rider) }}" class="btn-primary">Edit Rider</a>
                <a href="{{ route('admin.riders.index') }}" class="btn-secondary">Back to List</a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Rider Info -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow-md mb-8">
                <div class="p-6 border-b">
                    <h3 class="text-lg font-semibold">Rider Information</h3>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-xs sm:text-sm font-medium text-gray-700">Full Name</label>
                            <p class="mt-1 text-sm text-gray-900">{{ $rider->name }}</p>
                        </div>
                        <div>
                            <label class="block text-xs sm:text-sm font-medium text-gray-700">Email</label>
                            <p class="mt-1 text-sm text-gray-900">{{ $rider->email }}</p>
                        </div>
                        <div>
                            <label class="block text-xs sm:text-sm font-medium text-gray-700">Phone</label>
                            <p class="mt-1 text-sm text-gray-900">{{ $rider->phone }}</p>
                        </div>
                        <div>
                            <label class="block text-xs sm:text-sm font-medium text-gray-700">License Number</label>
                            <p class="mt-1 text-sm text-gray-900">{{ $rider->license_number }}</p>
                        </div>
                        <div>
                            <label class="block text-xs sm:text-sm font-medium text-gray-700">Vehicle Type</label>
                            <p class="mt-1 text-sm text-gray-900">{{ $rider->vehicle_type }}</p>
                        </div>
                        <div>
                            <label class="block text-xs sm:text-sm font-medium text-gray-700">Status</label>
                            <p class="mt-1">
                                @if($rider->status === 'active')
                                    <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-green-100 text-green-800">Active</span>
                                @else
                                    <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-red-100 text-red-800">Inactive</span>
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Parcels -->
            <div class="bg-white rounded-lg shadow-md">
                <div class="p-6 border-b">
                    <h3 class="text-lg font-semibold">Recent Deliveries</h3>
                </div>
                <div class="p-6">
                    @forelse($rider->parcels->take(5) as $parcel)
                        <div class="mb-4 p-4 border rounded-lg">
                            <div class="flex justify-between items-center">
                                <div>
                                    <h4 class="font-medium">{{ $parcel->tracking_number }}</h4>
                                    <p class="text-sm text-gray-500">{{ $parcel->recipient_name }}</p>
                                </div>
                                <div class="text-right">
                                    <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full
                                        @if($parcel->status === 'Delivered') bg-green-100 text-green-800
                                        @elseif($parcel->status === 'Out for Delivery') bg-blue-100 text-blue-800
                                        @else bg-yellow-100 text-yellow-800 @endif">
                                        {{ $parcel->status }}
                                    </span>
                                    <p class="text-sm text-gray-500 mt-1">{{ $parcel->updated_at->diffForHumans() }}</p>
                                </div>
                            </div>
                        </div>
                    @empty
                        <p class="text-gray-500 text-center py-8">No recent deliveries</p>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Sidebar Stats -->
        <div>
            <!-- Performance Stats -->
            <div class="bg-white rounded-lg shadow-md mb-8">
                <div class="p-6 border-b">
                    <h3 class="text-lg font-semibold">Performance Stats</h3>
                </div>
                <div class="p-6">
                    <div class="space-y-4">
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Total Deliveries</span>
                            <span class="font-semibold">{{ $rider->parcels->where('status', 'Delivered')->count() }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">On-Time Rate</span>
                            <span class="font-semibold text-green-600">95%</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Rating</span>
                            <span class="font-semibold">4.8/5.0</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Current Status</span>
                            <span class="font-semibold
                                @if($rider->current_status === 'available') text-green-600
                                @elseif($rider->current_status === 'on_duty') text-blue-600
                                @else text-yellow-600 @endif">
                                {{ ucfirst($rider->current_status ?? 'offline') }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-lg shadow-md">
                <div class="p-6 border-b">
                    <h3 class="text-lg font-semibold">Quick Actions</h3>
                </div>
                <div class="p-6">
                    <div class="space-y-3">
                        <a href="{{ route('admin.riders.assign-parcels', $rider) }}"
                           class="w-full bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded-md text-center block">
                            Assign Parcels
                        </a>
                        <a href="{{ route('admin.riders.performance.efficiency', $rider) }}"
                           class="w-full bg-green-600 hover:bg-green-700 text-white font-medium py-2 px-4 rounded-md text-center block">
                            View Performance
                        </a>
                        <a href="{{ route('admin.riders.gps-tracking', $rider) }}"
                           class="w-full bg-purple-600 hover:bg-purple-700 text-white font-medium py-2 px-4 rounded-md text-center block">
                            GPS Tracking
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


