@extends('layouts.admin')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-xl font-semibold">Create Span</h1>
        <a href="{{ route('admin.spans.index') }}" class="px-4 py-2 bg-gray-200 text-gray-800 rounded">Back</a>
    </div>

    <div class="bg-white rounded-lg shadow p-4">
        @if ($errors->any())
            <div class="mb-4 p-3 bg-red-100 text-red-700 rounded">
                <ul class="list-disc pl-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <form method="POST" action="{{ route('admin.spans.store') }}" class="grid grid-cols-1 md:grid-cols-2 gap-4">
            @csrf
            <div>
                <label class="block text-sm font-medium">Name</label>
                <input type="text" name="name" value="{{ old('name') }}" class="mt-1 border rounded p-2 w-full" required />
            </div>
            <div>
                <label class="block text-sm font-medium">Code</label>
                <input type="text" name="code" value="{{ old('code') }}" class="mt-1 border rounded p-2 w-full" required />
            </div>
            <div>
                <label class="block text-sm font-medium">Category</label>
                <input type="text" name="category" value="{{ old('category') }}" class="mt-1 border rounded p-2 w-full" />
            </div>
            <div>
                <label class="block text-sm font-medium">Owner</label>
                <input type="text" name="owner" value="{{ old('owner') }}" class="mt-1 border rounded p-2 w-full" />
            </div>
            <div>
                <label class="block text-sm font-medium">Status</label>
                <select name="status" class="mt-1 border rounded p-2 w-full">
                    <option value="active" {{ old('status')==='active'?'selected':'' }}>Active</option>
                    <option value="inactive" {{ old('status')==='inactive'?'selected':'' }}>Inactive</option>
                    <option value="archived" {{ old('status')==='archived'?'selected':'' }}>Archived</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium">Start Date</label>
                <input type="date" name="start_date" value="{{ old('start_date') }}" class="mt-1 border rounded p-2 w-full" />
            </div>
            <div>
                <label class="block text-sm font-medium">End Date</label>
                <input type="date" name="end_date" value="{{ old('end_date') }}" class="mt-1 border rounded p-2 w-full" />
            </div>
            <div class="md:col-span-2">
                <label class="block text-sm font-medium">Notes</label>
                <textarea name="notes" rows="4" class="mt-1 border rounded p-2 w-full">{{ old('notes') }}</textarea>
            </div>
            <div class="md:col-span-2">
                <button class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create</button>
            </div>
        </form>
    </div>
</div>
@endsection

